/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * KeyedReference.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.common;

import javax.persistence.Entity;
import javax.persistence.OneToOne;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableProperty;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.common.KeyedReference")
@Searchable(root = false)
public class KeyedReference extends SearchableBaseObject {

    /**
     * 
     */
    private static final long serialVersionUID = -2480467610839326683L;

    private TModel tmodel;

    @SearchableProperty
    private String keyName;

    @SearchableProperty
    private String keyValue;

    public KeyedReference() {
        super();
    }

    public KeyedReference(TModel tmodel, String keyName, String keyValue) {
        super();
        this.tmodel = tmodel;
        this.keyName = keyName;
        this.keyValue = keyValue;
    }

    @OneToOne
    public TModel getTmodel() {
        return tmodel;
    }

    public void setTmodel(TModel tmodelKeyRef) {
        this.tmodel = tmodelKeyRef;
    }

    public String getKeyName() {
        return keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getKeyValue() {
        return keyValue;
    }

    public void setKeyValue(String keyValue) {
        this.keyValue = keyValue;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof KeyedReference))
            return false;
        KeyedReference castOther = (KeyedReference) other;
        return new EqualsBuilder().append(tmodel, castOther.tmodel).append(keyName,
                castOther.keyName).append(keyValue, castOther.keyValue).isEquals();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(tmodel).append(keyName).append(keyValue).toHashCode();
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("keyName",
                this.keyName).append("tmodelKeyRef", this.tmodel).append("keyValue", this.keyValue)
                .toString();
    }

}
