/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * Link.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.common;

import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.compass.annotations.SearchableProperty;

/**
 * @author ofabre - ebmwebsourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.common.Link")
@Searchable(root = false)
public class Link extends SearchableBaseObject {

	/**
	 * 
	 */
	private static final long serialVersionUID = 641253541817833408L;

	@SearchableComponent(maxDepth = 2)
	private LinkedEntity from;

	@SearchableComponent(maxDepth = 2)
	private LinkedEntity to;

	@SearchableProperty
	private String type;

	@Override
	public boolean equals(final Object other) {
		if (!(other instanceof Link)) {
			return false;
		}
		final Link castOther = (Link) other;
		return new EqualsBuilder().append(this.from != null ? this.from.getId() : "null",
				castOther.from != null ? castOther.from.getId() : "null").append(
						this.to != null ? this.to.getId() : "null",
								castOther.to != null ? castOther.to.getId() : "null").append(this.type, castOther.type)
								.isEquals();
	}

	@Override
	public int hashCode() {
		return new HashCodeBuilder().append(this.from != null ? this.from.getId() : "null").append(
				this.to != null ? this.to.getId() : "null").append(this.type).toHashCode();
	}

	@ManyToOne
	@JoinColumn(name = "fromId", nullable = false)
	public LinkedEntity getFrom() {
		return this.from;
	}

	public void setFrom(final LinkedEntity from) {
		this.from = from;
	}

	@ManyToOne
	@JoinColumn(name = "toId", nullable = false)
	public LinkedEntity getTo() {
		return this.to;
	}

	public void setTo(final LinkedEntity to) {
		this.to = to;
	}

	public String getType() {
		return this.type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("to",
				this.to.getId()).append("type", this.type).append("from", this.from.getId())
				.toString();
	}

}
