/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * LinkedEntity.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.common;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;

/**
 * @author ofabre - ebmwebsourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.common.LinkedEntity")
@Inheritance(strategy = InheritanceType.JOINED)
@Searchable(root = false)
public class LinkedEntity extends SearchableBaseObject {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7684972596407987657L;

	/**
	 * All links where this class is a "from" part
	 */
	@SearchableComponent(maxDepth = 2)
	private Set<Link> fromLinks;

	/**
	 * All links where this class is a "to" part
	 */
	@SearchableComponent(maxDepth = 2)
	private Set<Link> toLinks;

	public LinkedEntity() {
		super();
		this.fromLinks = new HashSet<Link>();
		this.toLinks = new HashSet<Link>();
	}

	@Override
	public boolean equals(final Object other) {
		if (!(other instanceof LinkedEntity)) {
			return false;
		}
		final LinkedEntity castOther = (LinkedEntity) other;
		return new EqualsBuilder().append(this.fromLinks, castOther.fromLinks).append(this.toLinks,
				castOther.toLinks).isEquals();
	}

	@Override
	public int hashCode() {
		return new HashCodeBuilder().append(this.fromLinks).append(this.toLinks).toHashCode();
	}

	public void addFromLink(final Link link) {
		this.getFromLinks().add(link);
		link.setFrom(this);
	}

	public void addToLink(final Link link) {
		this.getToLinks().add(link);
		link.setTo(this);
	}

	public void removeFromLink(final Link link) {
		this.getFromLinks().remove(link);
		link.setFrom(null);
	}

	public void removeToLink(final Link link) {
		this.getToLinks().remove(link);
		link.setTo(null);
	}

	@OneToMany(cascade = CascadeType.REMOVE, mappedBy = "from")
	public Set<Link> getFromLinks() {
		return this.fromLinks;
	}

	public void setFromLinks(final Set<Link> fromLinks) {
		this.fromLinks = fromLinks;
	}

	@OneToMany(cascade = CascadeType.REMOVE, mappedBy = "to")
	public Set<Link> getToLinks() {
		return this.toLinks;
	}

	public void setToLinks(final Set<Link> toLinks) {
		this.toLinks = toLinks;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("fromLinks",
				this.fromLinks).append("toLinks", this.toLinks).toString();
	}

}
