/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * Binding.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.deployment;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.compass.annotations.SearchableProperty;
import org.hibernate.annotations.Cascade;
import org.ow2.dragon.persistence.bo.common.TModel;
import org.ow2.dragon.persistence.bo.specification.ServiceInterface;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.deployment.Binding")
@Searchable(root = false)
public class Binding extends TModel {

    /**
     * 
     */
    private static final long serialVersionUID = -2499871821906718599L;

    // private String id;

    private Set<BindingOperation> bindingOps;

    private Set<Endpoint> endpoints;

    @SearchableProperty
    private String fullName;

    /*
     * @SearchableComponent private Set<Standard> standards;
     */
    @SearchableComponent
    private Set<Protocol> protocols;

    @SearchableComponent
    private Set<Transport> transports;

    @SearchableComponent
    private ServiceInterface serviceInterface;

    private Set<ServiceSpecification> serviceSpecifications;

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof Binding))
            return false;
        Binding castOther = (Binding) other;
        return new EqualsBuilder().append(fullName, castOther.fullName).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(fullName).toHashCode();
    }

    public Binding() {
        this.endpoints = new HashSet<Endpoint>();
        this.bindingOps = new HashSet<BindingOperation>();
        this.serviceSpecifications = new HashSet<ServiceSpecification>();
        // this.standards = new HashSet<Standard>();
        this.protocols = new HashSet<Protocol>();
        this.transports = new HashSet<Transport>();
    }

    /**
     * Add a new binding operation to the binding operation list
     * 
     * @param endpoint
     */
    public void addBindingOp(final BindingOperation bindingOperation) {
        this.getBindingOps().add(bindingOperation);
    }

    public void removeBindingOp(final BindingOperation bindingOperation) {
        this.getBindingOps().remove(bindingOperation);
    }

    /**
     * Add a new endpoint to the binding endpoint list
     * 
     * @param endpoint
     */
    public void addEndpoint(final Endpoint endpoint) {
        this.getEndpoints().add(endpoint);
        endpoint.setBinding(this);
    }

    public void removeEndpoint(final Endpoint endpoint) {
        this.getEndpoints().remove(endpoint);
        endpoint.setBinding(null);
    }

    /**
     * Add a new standard to the binding standard list
     * 
     * @param standard
     * 
     *            public void addStandard(final Standard standard) {
     *            this.standards.add(standard); }
     */

    public void addProtocol(final Protocol protocol) {
        this.protocols.add(protocol);
    }

    public void addTransport(final Transport transport) {
        this.transports.add(transport);
    }

    @OneToMany(cascade = CascadeType.ALL)
    @OrderBy("signature")
    @Cascade( { org.hibernate.annotations.CascadeType.DELETE_ORPHAN })
    public Set<BindingOperation> getBindingOps() {
        return this.bindingOps;
    }

    @OneToMany(mappedBy = "binding")
    public Set<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public String getFullName() {
        return this.fullName;
    }

    @ManyToOne
    @JoinColumn(name = "serviceIntId")
    public ServiceInterface getServiceInterface() {
        return this.serviceInterface;
    }

    @ManyToMany(mappedBy = "bindings")
    public Set<ServiceSpecification> getServiceSpecifications() {
        return this.serviceSpecifications;
    }

    public void setBindingOps(final Set<BindingOperation> bindingOps) {
        this.bindingOps = bindingOps;
    }

    public void setEndpoints(final Set<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public void setFullName(final String fullName) {
        this.fullName = fullName;
    }

    public void setServiceInterface(final ServiceInterface serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public void setServiceSpecifications(final Set<ServiceSpecification> serviceSpecifications) {
        this.serviceSpecifications = serviceSpecifications;
    }

    /*
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(
                super.toString()).append("serviceInterface", this.serviceInterface)./*
                                                                                     * append(
                                                                                     * "standards"
                                                                                     * ,
                                                                                     * this
                                                                                     * .
                                                                                     * standards
                                                                                     * )
                                                                                     * .
                                                                                     */append(
                "bindingOps", this.bindingOps).append("fullName", this.fullName).toString();
    }

    @ManyToMany
    public Set<Protocol> getProtocols() {
        return protocols;
    }

    public void setProtocols(Set<Protocol> protocols) {
        this.protocols = protocols;
    }

    @ManyToMany
    public Set<Transport> getTransports() {
        return transports;
    }

    public void setTransports(Set<Transport> transports) {
        this.transports = transports;
    }

    /*
     * @ManyToMany public Set<Standard> getStandards() { return standards; }
     * 
     * public void setStandards(Set<Standard> standards) { this.standards =
     * standards; }
     */

}
