/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * BindingOperation.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.deployment;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.ow2.dragon.persistence.bo.common.NonSearchableBaseObject;
import org.ow2.dragon.persistence.bo.specification.SpecifiedOperation;
import org.ow2.dragon.persistence.bo.specification.SpecifiedOperation.OpStyleType;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.deployment.BindingOperation")
public class BindingOperation extends NonSearchableBaseObject {

    /**
     * 
     */
    private static final long serialVersionUID = 5795063535159751966L;

    private String signature;

    private OpStyleType style;

    private SpecifiedOperation specifiedOp;

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof BindingOperation)) {
            return false;
        }
        final BindingOperation castOther = (BindingOperation) other;
        return new EqualsBuilder().append(this.signature, castOther.signature).isEquals();
    }

    @Lob
    @Column(length = 1048576)
    public String getSignature() {
        return this.signature;
    }

    @ManyToOne
    @JoinColumn(name = "specifiedOpId", nullable = false)
    public SpecifiedOperation getSpecifiedOp() {
        return this.specifiedOp;
    }

    @Enumerated(EnumType.STRING)
    public OpStyleType getStyle() {
        return this.style;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.signature).toHashCode();
    }

    public void setSignature(final String signature) {
        this.signature = signature;
    }

    public void setSpecifiedOp(final SpecifiedOperation specifiedOp) {
        this.specifiedOp = specifiedOp;
    }

    public void setStyle(final OpStyleType style) {
        this.style = style;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("signature",
                this.signature).append("style", this.style).toString();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Comparable#compareTo(java.lang.Object)
     */
    public int compareTo(final BindingOperation other) {
        return new CompareToBuilder().append(signature, other.signature).toComparison();
    }

}
