/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * TechnicalService.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.deployment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.compass.annotations.SearchableProperty;
import org.hibernate.annotations.Cascade;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.CommunityObj;
import org.ow2.dragon.persistence.bo.common.Description;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.deployment.TechnicalService")
@Searchable
public class TechnicalService extends CommunityObj {

    /**
     * 
     */
    private static final long serialVersionUID = 1731694441773447781L;

    @SearchableComponent
    private Set<Endpoint> endpoints;

    // Remove this link 'cause wsdl 1.1 spec allow multiple interfaces for the
    // same service
    // private ServiceInterface serviceInterface;

    private Set<ServiceSpecification> serviceSpecifications;

    @SearchableComponent
    private Set<SimpleFile> relatedDocs;

    // UDDI fields
    @SearchableComponent
    private List<Name> names;

    @SearchableProperty
    private String fullName;

    @SearchableComponent
    private List<Description> descriptions;

    // Fields replaced by the generic field : descriptions
    // private String purpose;
    // private String otherInformation;

    @SearchableComponent
    private CategoryBag categoryBag;

    // Field replaced by the field categoryBag
    // private String category;

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof TechnicalService))
            return false;
        TechnicalService castOther = (TechnicalService) other;
        return new EqualsBuilder().append(names, castOther.names).append(fullName,
                castOther.fullName).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(names).append(fullName).toHashCode();
    }

    public TechnicalService() {
        super();
        this.endpoints = new HashSet<Endpoint>();
        this.serviceSpecifications = new HashSet<ServiceSpecification>();
        this.relatedDocs = new HashSet<SimpleFile>();
        this.names = new ArrayList<Name>();
        this.descriptions = new ArrayList<Description>();
    }

    public void addDescription(final Description description) {
        this.getDescriptions().add(description);
    }

    public void addName(final Name name) {
        this.getNames().add(name);
    }

    public void addEndpoint(final Endpoint endpoint) {
        this.getEndpoints().add(endpoint);
        endpoint.setTechnicalService(this);
    }

    public void removeEndpoint(final Endpoint endpoint) {
        this.getEndpoints().remove(endpoint);
        endpoint.setTechnicalService(null);
    }

    public void addServiceSpec(final ServiceSpecification serviceSpecification) {
        this.getServiceSpecifications().add(serviceSpecification);
        serviceSpecification.getTechnicalServices().add(this);
    }

    public void removeServiceSpec(final ServiceSpecification serviceSpecification) {
        this.getServiceSpecifications().remove(serviceSpecification);
        serviceSpecification.getTechnicalServices().remove(this);
    }

    public void addRelatedDoc(final SimpleFile relatedDoc) {
        this.getRelatedDocs().add(relatedDoc);
    }

    @OneToMany(cascade = CascadeType.ALL)
    @Cascade( { org.hibernate.annotations.CascadeType.DELETE_ORPHAN })
    public List<Name> getNames() {
        return names;
    }

    public void setNames(List<Name> names) {
        this.names = names;
    }

    @OneToMany(cascade = CascadeType.ALL)
    @Cascade( { org.hibernate.annotations.CascadeType.DELETE_ORPHAN })
    public List<Description> getDescriptions() {
        return descriptions;
    }

    public void setDescriptions(List<Description> descriptions) {
        this.descriptions = descriptions;
    }

    @OneToOne(cascade = CascadeType.ALL)
    public CategoryBag getCategoryBag() {
        return categoryBag;
    }

    public void setCategoryBag(CategoryBag categoryBag) {
        this.categoryBag = categoryBag;
    }

    public void setEndpoints(Set<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    @OneToMany(cascade = CascadeType.ALL, mappedBy = "technicalService")
    public Set<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    /*
     * @ManyToOne
     * 
     * @JoinColumn(name = "serviceIntId", nullable = false) public
     * ServiceInterface getServiceInterface() { return this.serviceInterface; }
     */

    @ManyToMany(mappedBy = "technicalServices")
    public Set<ServiceSpecification> getServiceSpecifications() {
        return this.serviceSpecifications;
    }

    /*
     * public void setServiceInterface(final ServiceInterface serviceInterface)
     * { this.serviceInterface = serviceInterface; }
     */

    public void setServiceSpecifications(final Set<ServiceSpecification> serviceSpecifications) {
        this.serviceSpecifications = serviceSpecifications;
    }

    @ManyToMany
    public Set<SimpleFile> getRelatedDocs() {
        return relatedDocs;
    }

    public void setRelatedDocs(Set<SimpleFile> relatedDocs) {
        this.relatedDocs = relatedDocs;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(
                super.toString()).append("descriptions", this.descriptions).append("categoryBag",
                this.categoryBag).append("names", this.names).append("endpoints", this.endpoints)
                .append("relatedDocs", this.relatedDocs).toString();
    }

    public String getFullName() {
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }
}
