/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * PhoneNumber.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.organization;

import javax.persistence.Entity;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableProperty;
import org.ow2.dragon.persistence.bo.common.SearchableBaseObject;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.organization.AddressLine")
@Searchable(root = false)
public class AddressLine extends SearchableBaseObject {

    /**
     * 
     */
    private static final long serialVersionUID = 7656856118873249206L;

    private String keyName;

    private String keyValue;

    @SearchableProperty
    private String addressLine;

    public String getKeyName() {
        return keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getKeyValue() {
        return keyValue;
    }

    public void setKeyValue(String keyValue) {
        this.keyValue = keyValue;
    }

    public String getAddressLine() {
        return addressLine;
    }

    public void setAddressLine(String addressLine) {
        this.addressLine = addressLine;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof AddressLine))
            return false;
        AddressLine castOther = (AddressLine) other;
        return new EqualsBuilder().append(keyName, castOther.keyName).append(keyValue,
                castOther.keyValue).append(addressLine, castOther.addressLine).isEquals();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(keyName).append(keyValue).append(addressLine)
                .toHashCode();
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("addressLine",
                this.addressLine).append("keyName", this.keyName).append("keyValue", this.keyValue)
                .toString();
    }

}
