/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * OrganizationUnit.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.organization;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.compass.annotations.SearchableProperty;
import org.hibernate.annotations.Cascade;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.KeyedReference;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.organization.OrganizationUnit")
@Searchable
public class OrganizationUnit extends Party {

    /**
     * 
     */
    private static final long serialVersionUID = 2669421239273081631L;

    private boolean isLegalEntity;

    private List<DiscoveryUrl> discoveryUrls;

    private List<KeyedReference> identifierBag;

    @SearchableComponent
    private CategoryBag categoryBag;

    private Set<Party> parties;

    private Set<Post> posts;

    @SearchableProperty
    private String type;

    public OrganizationUnit() {
        this.parties = new HashSet<Party>();
        this.posts = new HashSet<Post>();
        this.discoveryUrls = new ArrayList<DiscoveryUrl>();
        this.identifierBag = new ArrayList<KeyedReference>();
    }

    public void addIdentifier(KeyedReference keyedReference) {
        this.getIdentifierBag().add(keyedReference);
    }

    public void addParty(final Party party) {
        this.getParties().add(party);
        party.setParentOrganization(this);
    }

    public void removeParty(final Party party) {
        this.getParties().remove(party);
        party.setParentOrganization(null);
    }

    public void addPost(final Post post) {
        this.getPosts().add(post);
    }

    public void addDiscoveryUrl(DiscoveryUrl discoveryUrl) {
        this.getDiscoveryUrls().add(discoveryUrl);
    }

    @OneToMany(cascade = CascadeType.ALL)
    @Cascade( { org.hibernate.annotations.CascadeType.DELETE_ORPHAN })
    public List<DiscoveryUrl> getDiscoveryUrls() {
        return this.discoveryUrls;
    }

    @OneToMany(cascade = CascadeType.ALL, mappedBy = "parentOrganization")
    public Set<Party> getParties() {
        return this.parties;
    }

    @ManyToMany
    public Set<Post> getPosts() {
        return this.posts;
    }

    public String getType() {
        return this.type;
    }

    public boolean isLegalEntity() {
        return this.isLegalEntity;
    }

    public void removePost(final Post post) {
        this.getPosts().remove(post);
    }

    public void setDiscoveryUrls(final List<DiscoveryUrl> discoveryUrls) {
        this.discoveryUrls = discoveryUrls;
    }

    public void setLegalEntity(final boolean isLegalEntity) {
        this.isLegalEntity = isLegalEntity;
    }

    public void setParties(final Set<Party> parties) {
        this.parties = parties;
    }

    public void setPosts(final Set<Post> posts) {
        this.posts = posts;
    }

    public void setType(final String type) {
        this.type = type;
    }

    @OneToMany(cascade = CascadeType.ALL)
    @JoinTable(name="OrgaUnit_KeyedRef")
    @Cascade( { org.hibernate.annotations.CascadeType.DELETE_ORPHAN })
    public List<KeyedReference> getIdentifierBag() {
        return identifierBag;
    }

    public void setIdentifierBag(List<KeyedReference> identifierBag) {
        this.identifierBag = identifierBag;
    }

    @OneToOne(cascade = CascadeType.ALL)
    public CategoryBag getCategoryBag() {
        return categoryBag;
    }

    public void setCategoryBag(CategoryBag categoryBag) {
        this.categoryBag = categoryBag;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof OrganizationUnit))
            return false;
        OrganizationUnit castOther = (OrganizationUnit) other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(identifierBag,
                castOther.identifierBag).isEquals();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(identifierBag)
                .toHashCode();
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(
                super.toString()).append("discoveryUrls", this.discoveryUrls).append("categoryBag",
                this.categoryBag).append("type", this.type).append("identifierBag",
                this.identifierBag).append("isLegalEntity", this.isLegalEntity).append("posts",
                this.posts).append("parties", this.parties).toString();
    }

}
