/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ManagedAgreeement.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.sla;

import javax.persistence.Entity;
import javax.persistence.OneToOne;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableProperty;
import org.ow2.dragon.persistence.bo.common.SearchableBaseObject;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.persistence.bo.organization.Party;

@Entity(name = "org.ow2.dragon.persistence.bo.sla.ManagedAgreeement")
@Searchable
public class ManagedAgreement extends SearchableBaseObject {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    private SimpleFile agreementFile;

    private Party client;

    private Party provider;

    private String state;

    private Endpoint endpoint;
    

    public ManagedAgreement() {
        super();
    }

    public ManagedAgreement(boolean isEditable) {
        super();
    }

    /**
     * @return the client
     */
    @OneToOne
    public Party getClient() {
        return client;
    }

    /**
     * @param client
     *            the client to set
     */
    public void setClient(Party client) {
        this.client = client;
    }

    /**
     * @return the idFile
     */
    @OneToOne
    public SimpleFile getAgreementFile() {
        return agreementFile;
    }

    /**
     * @param idFile
     *            the idFile to set
     */
    public void setAgreementFile(SimpleFile agreementFile) {
        this.agreementFile = agreementFile;
    }

    /**
     * @return the provider
     */
    @OneToOne
    public Party getProvider() {
        return provider;
    }

    /**
     * @param provider
     *            the provider to set
     */
    public void setProvider(Party provider) {
        this.provider = provider;
    }

    // Search properties
    private String name;

    private String initiator;

    private String responder;

    @SearchableProperty
    public String getName() {
        return this.name;
    }

    @SearchableProperty
    public String getInitiator() {
        return this.initiator;
    }

    @SearchableProperty
    public String getResponder() {
        return this.responder;
    }

    public void setName(String value) {
        this.name = value;
    }

    public void setInitiator(String value) {
        this.initiator = value;
    }

    public void setResponder(String value) {
        this.responder = value;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof ManagedAgreement))
            return false;
        ManagedAgreement castOther = (ManagedAgreement) other;
        return new EqualsBuilder().append(getName(), castOther.getName()).append(getInitiator(),
                castOther.getInitiator()).append(getResponder(), castOther.getResponder())
                .isEquals();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(getName()).append(getInitiator())
                .append(getResponder()).toHashCode();
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("agreementFile",
                this.agreementFile).append("provider", this.provider).append("client", this.client)
                .toString();
    }

    @SearchableProperty
    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @OneToOne
    public Endpoint getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }
}
