/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ServiceInterface.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.specification;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.hibernate.annotations.Cascade;
import org.ow2.dragon.persistence.bo.common.TModel;
import org.ow2.dragon.persistence.bo.deployment.Binding;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.specification.ServiceInterface")
@Searchable(root = false)
public class ServiceInterface extends TModel {

    /**
     * 
     */
    private static final long serialVersionUID = 4970986248323341443L;

    private Set<Binding> bindings;

    private String fullName;

    // private String id;

    private Set<ServiceSpecification> serviceSpecs;

    private Set<SpecifiedOperation> specifiedOps;

    // Remove this link 'cause wsdl 1.1 spec allow multiple interfaces for the
    // same service
    // private Set<TechnicalService> technicalServices;

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof ServiceInterface))
            return false;
        ServiceInterface castOther = (ServiceInterface) other;
        return new EqualsBuilder().append(fullName, castOther.fullName).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(fullName).toHashCode();
    }

    public ServiceInterface() {
        // this.technicalServices = new HashSet<TechnicalService>();
        this.specifiedOps = new HashSet<SpecifiedOperation>();
        this.bindings = new HashSet<Binding>();
        this.serviceSpecs = new HashSet<ServiceSpecification>();
    }

    public void addBinding(final Binding binding) {
        this.getBindings().add(binding);
        binding.setServiceInterface(this);
    }

    public void removeBinding(final Binding binding) {
        this.getBindings().remove(binding);
        binding.setServiceInterface(null);
    }

    public void addSpecifiedOp(final SpecifiedOperation specifiedOperation) {
        this.getSpecifiedOps().add(specifiedOperation);
        specifiedOperation.setServiceInterface(this);
    }

    public void removeSpecifiedOp(final SpecifiedOperation specifiedOperation) {
        this.getSpecifiedOps().remove(specifiedOperation);
        specifiedOperation.setServiceInterface(null);
    }

    public void addServiceSpec(ServiceSpecification serviceSpecification) {
        this.getServiceSpecs().add(serviceSpecification);
        serviceSpecification.getServiceInterfaces().add(this);
    }

    public void removeServiceSpec(ServiceSpecification serviceSpecification) {
        this.getServiceSpecs().remove(serviceSpecification);
        serviceSpecification.getServiceInterfaces().remove(this);
    }

    /*
     * public void addTechnicalService(final TechnicalService technicalService)
     * { this.getTechnicalServices().add(technicalService);
     * technicalService.setServiceInterface(this); }
     */

    @OneToMany(mappedBy = "serviceInterface")
    public Set<Binding> getBindings() {
        return this.bindings;
    }

    public String getFullName() {
        return this.fullName;
    }

    /*
     * @Id
     * 
     * @GeneratedValue(generator = "system-uuid")
     * 
     * @GenericGenerator(name = "system-uuid", strategy = "uuid")
     * 
     * @SearchableId public String getId() { return this.id; }
     */

    @ManyToMany(mappedBy = "serviceInterfaces")
    public Set<ServiceSpecification> getServiceSpecs() {
        return this.serviceSpecs;
    }

    @OneToMany(cascade = CascadeType.ALL)
    @JoinTable(name="ServInterface_SpecOperation")
    @Cascade( { org.hibernate.annotations.CascadeType.DELETE_ORPHAN })
    @SearchableComponent
    public Set<SpecifiedOperation> getSpecifiedOps() {
        return this.specifiedOps;
    }

    /*
     * @OneToMany(mappedBy = "serviceInterface") public Set<TechnicalService>
     * getTechnicalServices() { return this.technicalServices; }
     */

    public void setBindings(final Set<Binding> bindings) {
        this.bindings = bindings;
    }

    public void setFullName(final String fullName) {
        this.fullName = fullName;
    }

    /*
     * public void setId(final String id) { this.id = id; }
     */

    public void setServiceSpecs(final Set<ServiceSpecification> serviceSpecs) {
        this.serviceSpecs = serviceSpecs;
    }

    public void setSpecifiedOps(final Set<SpecifiedOperation> specifiedOps) {
        this.specifiedOps = specifiedOps;
    }

    /*
     * public void setTechnicalServices(final Set<TechnicalService>
     * technicalServices) { this.technicalServices = technicalServices; }
     */

    /*
     * @see java.lang.Object#toString()
     * 
     * @Override public String toString() { return new ToStringBuilder(this,
     * ToStringStyle.MULTI_LINE_STYLE).append("specifiedOps",
     * this.specifiedOps).append("id", this.id).append("name",
     * this.name).toString(); }
     */

}
