/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ExecutionEnvironmentManager.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.technology;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.Entity;
import javax.persistence.OneToMany;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableProperty;
import org.ow2.dragon.persistence.bo.common.SearchableBaseObject;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.technology.ExecutionEnvironmentManager")
@Searchable
public class ExecutionEnvironmentManager extends SearchableBaseObject {

    /**
     * 
     */
    private static final long serialVersionUID = -3465946520150021079L;

    private String name;

    private String address;

    private Set<Node> managedNodes;

    public ExecutionEnvironmentManager() {
        this.managedNodes = new HashSet<Node>();
    }

    public void addNode(Node node) {
        this.managedNodes.add(node);
        node.setManager(this);
    }

    public void removeNode(Node node) {
        this.managedNodes.remove(node);
        node.setManager(null);
    }

    @SearchableProperty
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @OneToMany(mappedBy = "manager")
    public Set<Node> getManagedNodes() {
        return managedNodes;
    }

    public void setManagedNodes(Set<Node> managedNodes) {
        this.managedNodes = managedNodes;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof ExecutionEnvironmentManager))
            return false;
        ExecutionEnvironmentManager castOther = (ExecutionEnvironmentManager) other;
        return new EqualsBuilder().append(name, castOther.name).isEquals();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(name).toHashCode();
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("address",
                this.address).append("managedNodes", this.managedNodes).append("name", this.name)
                .toString();
    }

}
