/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * Node.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.technology;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableProperty;
import org.ow2.dragon.persistence.bo.common.SearchableBaseObject;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.technology.Node")
@Inheritance(strategy = InheritanceType.JOINED)
@Searchable(root = false)
public class Node extends SearchableBaseObject {

    /**
     * 
     */
    private static final long serialVersionUID = 8132001335710138670L;

    private String name;

    private String type;

    private String ipv4Address;

    private boolean isPrototypical;

    private int expectedQuantity;

    private Set<Endpoint> endpoints;

    private ExecutionEnvironmentManager manager;

    public Node() {
        this.endpoints = new HashSet<Endpoint>();
    }

    @OneToMany(mappedBy = "hostNode")
    public Set<Endpoint> getEndpoints() {
        return endpoints;
    }

    public void setEndpoints(Set<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public void addEndpoint(final Endpoint endpoint) {
        this.getEndpoints().add(endpoint);
        endpoint.setHostNode(this);
    }

    public void removeEndpoint(final Endpoint endpoint) {
        this.getEndpoints().remove(endpoint);
        endpoint.setHostNode(null);
    }

    @SearchableProperty
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isPrototypical() {
        return isPrototypical;
    }

    public void setPrototypical(boolean isPrototypical) {
        this.isPrototypical = isPrototypical;
    }

    public int getExpectedQuantity() {
        return expectedQuantity;
    }

    public void setExpectedQuantity(int expectedQuantity) {
        this.expectedQuantity = expectedQuantity;
    }

    @SearchableProperty
    public String getIpv4Address() {
        return ipv4Address;
    }

    public void setIpv4Address(String ipv4Address) {
        this.ipv4Address = ipv4Address;
    }

    @ManyToOne
    @JoinColumn(name = "execEnvManagerId")
    public ExecutionEnvironmentManager getManager() {
        return manager;
    }

    public void setManager(ExecutionEnvironmentManager manager) {
        this.manager = manager;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof Node))
            return false;
        Node castOther = (Node) other;
        return new EqualsBuilder().append(name, castOther.name).isEquals();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(name).toHashCode();
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("isPrototypical",
                this.isPrototypical).append("ipv4Address", this.ipv4Address).append("type",
                this.type).append("expectedQuantity", this.expectedQuantity).append("endpoints",
                this.endpoints).append("name", this.name).toString();
    }

}
