/**
 * 
 */
package org.ow2.dragon.persistence.bo.wsdm;

import javax.persistence.Entity;
import javax.persistence.OneToOne;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.ow2.dragon.persistence.bo.common.CommunityObj;
import org.ow2.dragon.persistence.bo.deployment.BindingOperation;

/**
 * @author aruffie
 *
 */
@Entity(name = "org.ow2.dragon.persistence.bo.wsdm.QoSMetric")
@Searchable(root = false)
public class QoSMetric extends CommunityObj implements Comparable<QoSMetric> {

    /**
     * 
     */
    private static final long serialVersionUID = -6379501241252064397L;
    
    private BindingOperation bindingOperation;
    
    private long serviceTime;
    
    private long lastRequestSize;
    
    private long lastResponseSize;
    
    private long lastResponseTime;
    
    private long maxRequestSize;
    
    private long maxResponseSize;
    
    private long maxResponseTime;
    
    private long numberOfFailedRequest;
    
    private long numberOfRequests;
    
    private long numberOfSuccessfulRequest;
    /* (non-Javadoc)
     * @see org.ow2.dragon.persistence.bo.common.BaseObject#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if(!(other instanceof QoSMetric)){
            return false;
        }
        final QoSMetric castOther = (QoSMetric) other;
        return new EqualsBuilder().append(this.bindingOperation, castOther.bindingOperation).isEquals();
    }

    /* (non-Javadoc)
     * @see org.ow2.dragon.persistence.bo.common.BaseObject#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.bindingOperation).toHashCode();
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SIMPLE_STYLE).append("binding-operation", this.bindingOperation).toString();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Comparable#compareTo(java.lang.Object)
     */
    public int compareTo(final QoSMetric other) {
        return new CompareToBuilder().append(this.bindingOperation,other.bindingOperation).toComparison();
    }

    @OneToOne
    public BindingOperation getBindingOperation() {
        return bindingOperation;
    }

    public void setBindingOperation(BindingOperation bindingOperation) {
        this.bindingOperation = bindingOperation;
    }

    public long getServiceTime() {
        return serviceTime;
    }

    public void setServiceTime(long serviceTime) {
        this.serviceTime = serviceTime;
    }

    public long getLastRequestSize() {
        return lastRequestSize;
    }

    public void setLastRequestSize(long lastRequestSize) {
        this.lastRequestSize = lastRequestSize;
    }

    public long getLastResponseSize() {
        return lastResponseSize;
    }

    public void setLastResponseSize(long lastResponseSize) {
        this.lastResponseSize = lastResponseSize;
    }

    public long getLastResponseTime() {
        return lastResponseTime;
    }

    public void setLastResponseTime(long lastResponseTime) {
        this.lastResponseTime = lastResponseTime;
    }

    public long getMaxRequestSize() {
        return maxRequestSize;
    }

    public void setMaxRequestSize(long maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public long getMaxResponseSize() {
        return maxResponseSize;
    }

    public void setMaxResponseSize(long maxResponseSize) {
        this.maxResponseSize = maxResponseSize;
    }

    public long getMaxResponseTime() {
        return maxResponseTime;
    }

    public void setMaxResponseTime(long maxResponseTime) {
        this.maxResponseTime = maxResponseTime;
    }

    public long getNumberOfFailedRequest() {
        return numberOfFailedRequest;
    }

    public void setNumberOfFailedRequest(long numberOfFailedRequest) {
        this.numberOfFailedRequest = numberOfFailedRequest;
    }

    public long getNumberOfRequests() {
        return numberOfRequests;
    }

    public void setNumberOfRequests(long numberOfRequests) {
        this.numberOfRequests = numberOfRequests;
    }

    public long getNumberOfSuccessfulRequest() {
        return numberOfSuccessfulRequest;
    }

    public void setNumberOfSuccessfulRequest(long numberOfSuccessfulRequest) {
        this.numberOfSuccessfulRequest = numberOfSuccessfulRequest;
    }
}
