/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * GenericHibernateCompassDAOImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.NonUniqueResultException;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.aop.annotation.CheckArgumentsNotNull;
import org.ow2.dragon.persistence.bo.common.SearchableBaseObject;
import org.ow2.dragon.persistence.util.CompassQueryHelper;

import com.trg.search.IMutableSearch;
import com.trg.search.SearchResult;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
public class GenericHibernateCompassDAOImpl<T extends SearchableBaseObject, PK extends Serializable>
        implements GenericUnifiedDAO<T, PK> {

    private GenericOSEMDAO<T, PK> genericOSEMDAO;

    private GenericORMDAO<T, PK> genericORMDAO;

    /**
     * {@inheritDoc}
     */
    public boolean exists(PK id) {
        return genericORMDAO.exists(id);
    }

    /**
     * {@inheritDoc}
     */
    public List<T> findByNamedQuery(String queryName, Map<String, Object> queryParams) {
        return genericORMDAO.findByNamedQuery(queryName, queryParams);
    }

    /**
     * {@inheritDoc}
     */
    public T get(PK id) {
        return genericORMDAO.get(id);
    }

    /**
     * {@inheritDoc}
     */
    public List<T> getAll(RequestOptions requestOptionsTO) {
        return genericORMDAO.getAll(requestOptionsTO);
    }

    /**
     * {@inheritDoc}
     */
    public List<T> getAll() {
        return genericORMDAO.getAll();
    }

    /**
     * {@inheritDoc}
     */
    public List<T> getAllDistinct() {
        return genericORMDAO.getAllDistinct();
    }

    /**
     * {@inheritDoc}
     */
    public void remove(PK id) {
        genericORMDAO.remove(id);

    }

    /**
     * {@inheritDoc}
     */
    public T save(T object) {
        return genericORMDAO.save(object);
    }

    /**
     * {@inheritDoc}
     */
    public List<T> search(String query) {
        return genericOSEMDAO.search(query);
    }

    /**
     * {@inheritDoc}
     */
    public List<T> searchEquals(String[] criteria, String[] properties,
            RequestOptions requestOptionsTO) {
        return genericORMDAO.searchEquals(criteria, properties, requestOptionsTO);
    }

    /**
     * {@inheritDoc}
     */
    public List<T> searchLike(String[] criteria, String[] properties,
            RequestOptions requestOptionsTO) {
        return genericORMDAO.searchLike(criteria, properties, requestOptionsTO);
    }

    /**
     * {@inheritDoc}
     */
    public List<T> searchORMResult(String query) {
        return this.searchORMResult(query, null);
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("unchecked")
    public List<T> searchORMResult(String query, RequestOptions requestOptions) {
        List<T> osemResults = this.search(query);
        List<PK> ids = new ArrayList<PK>();
        for (T t : osemResults) {
            ids.add((PK) t.getId());
        }
        return this.getAll(ids, requestOptions);
    }

    public List<T> getAll(List<PK> ids, RequestOptions requestOptions) {
        return this.genericORMDAO.getAll(ids, requestOptions);
    }

    public List<T> getAll(List<PK> ids) {
        return this.getAll(ids, null);
    }

    /**
     * {@inheritDoc}
     * 
     * @throws DAOLayerException
     */
    @CheckAllArgumentsNotNull
    public List<T> searchORMResult(String[] criteria, String[] searchedProperties)
            throws DAOLayerException {
        return this.searchORMResult(criteria, searchedProperties, null);
    }

    /**
     * {@inheritDoc}
     * 
     * @throws DAOLayerException
     */
    @CheckArgumentsNotNull
    public List<T> searchORMResult(String[] criteria, String[] searchedProperties,
            RequestOptions requestOptions) throws DAOLayerException {
        if (criteria.length == 0 || searchedProperties.length == 0) {
            throw new DAOLayerException("Search criterii and properties can't be empty.");
        }
        String query = CompassQueryHelper.decorateQuery(criteria, searchedProperties,
                genericOSEMDAO.getManipulatedType().getSimpleName());
        return this.searchORMResult(query, requestOptions);
    }

    public void setGenericOSEMDAO(GenericOSEMDAO<T, PK> genericOSEMDAO) {
        this.genericOSEMDAO = genericOSEMDAO;
    }

    public void setGenericORMDAO(GenericORMDAO<T, PK> genericORMDAO) {
        this.genericORMDAO = genericORMDAO;
    }

    /**
     * {@inheritDoc}
     */
    public int count(IMutableSearch search) {
        return genericORMDAO.count(search);
    }

    /**
     * {@inheritDoc}
     */
    public List<T> search(IMutableSearch search) {
        return genericORMDAO.search(search);
    }

    /**
     * {@inheritDoc}
     */
    public SearchResult<T> searchAndCount(IMutableSearch search) {
        return genericORMDAO.searchAndCount(search);
    }

    /**
     * {@inheritDoc}
     */
    public T searchUnique(IMutableSearch search) throws NonUniqueResultException {
        return genericORMDAO.searchUnique(search);
    }

    protected GenericOSEMDAO<T, PK> getGenericOSEMDAO() {
        return genericOSEMDAO;
    }

    protected GenericORMDAO<T, PK> getGenericORMDAO() {
        return genericORMDAO;
    }

    public void remove(T object) {
        genericORMDAO.remove(object);
    }

}
