/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * UniversalHibernateDAOImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.dao;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.hibernate.NonUniqueResultException;
import org.ow2.dragon.persistence.util.HibernateQueryHelper;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

import com.trg.search.IMutableSearch;
import com.trg.search.ISearch;
import com.trg.search.Search;
import com.trg.search.SearchResult;
import com.trg.search.hibernate.HibernateSearchProcessor;

/**
 * This class serves as the a class that can CRUD any object witout any Spring
 * configuration. The only downside is it does require casting from Object to
 * the object class.
 * 
 * @author Bryan Noll, Olivier FABRE
 */
public class UniversalHibernateDAOImpl extends HibernateDaoSupport implements UniversalORMDAO {
    /**
     * Log variable for all child classes. Uses LogFactory.getLog(getClass())
     * from Commons Logging
     */
    private Logger log = Logger.getLogger(this.getClass());

    /**
     * {@inheritDoc}
     */
    public Object save(Object o) {
        getHibernateTemplate().saveOrUpdate(o);
        return o;
    }

    /**
     * {@inheritDoc}
     */
    public Object get(Class clazz, Serializable id) {
        Object o = getHibernateTemplate().get(clazz, id);

        // if (o == null) {
        // throw new ObjectRetrievalFailureException(clazz, id);
        // }

        return o;
    }

    /**
     * {@inheritDoc}
     */
    public List getAll(Class clazz) {
        return getHibernateTemplate().loadAll(clazz);
    }

    /**
     * {@inheritDoc}
     */
    public void remove(Class clazz, Serializable id) {
        Object object = get(clazz, id);
        // if object is null, skip removal
        if (object != null) {
            getHibernateTemplate().delete(object);
        }
    }

    /**
     * {@inheritDoc}
     */
    public void remove(Object object) {
        // if object is null, skip removal
        if (object != null) {
            getHibernateTemplate().delete(object);
        }
    }

    /**
     * {@inheritDoc}
     */
    public List getAll(Class clazz, List ids) {
        return this.getAll(clazz, ids, null);
    }

    /**
     * {@inheritDoc}
     */
    public List getAll(Class clazz, List ids, RequestOptions requestOptions) {
        /*
         * List result = new ArrayList(); if (ids != null && !ids.isEmpty()) {
         * String simpleTypeName = clazz.getSimpleName(); String fullTypeName =
         * clazz.getName();
         * 
         * HibernateQueryHelper queryBuilder = new HibernateQueryHelper();
         * 
         * queryBuilder.appendSelectStatement(simpleTypeName, fullTypeName);
         * 
         * queryBuilder.WHERE().pad();
         * queryBuilder.appendInList(simpleTypeName.toLowerCase() + ".id", ids);
         * 
         * queryBuilder.appendSortOption(requestOptions,
         * simpleTypeName.toLowerCase()); Query query =
         * queryBuilder.buildHibernatePaginatedQuery(this.getSession(),
         * requestOptions);
         * 
         * log.debug("Hibernate Query: " + query); result = query.list(); }
         * return result;
         */
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor
                .getInstanceForSessionFactory(getSessionFactory());

        Search search = (Search) HibernateQueryHelper.createSearchContext(clazz, null, null,
                requestOptions, null);
        search.addFilterIn("id", ids);

        return searchProcessor.search(getSession(), search);
    }

    /**
     * {@inheritDoc}
     */
    public List getAll(Class clazz, RequestOptions requestOptions) {
        /*
         * List result = new ArrayList(); final DetachedCriteria
         * detachedCriteria = DetachedCriteria.forClass(clazz); result =
         * HibernateQueryHelper
         * .sortAndPaginateByCriteria(this.getHibernateTemplate(),
         * requestOptions, detachedCriteria); return result;
         */
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor
                .getInstanceForSessionFactory(getSessionFactory());

        ISearch search = HibernateQueryHelper.createSearchContext(clazz, null, null,
                requestOptions, null);

        return searchProcessor.search(getSession(), search);
    }

    /**
     * {@inheritDoc}
     */
    public void removeAll(Class clazz, List ids) {
        List toRemove = getAll(clazz, ids);
        if (toRemove != null && !toRemove.isEmpty()) {
            this.getHibernateTemplate().deleteAll(toRemove);
        }
    }

    /**
     * {@inheritDoc}
     */
    public void removeAll(List objects) {
        if (objects != null && !objects.isEmpty()) {
            this.getHibernateTemplate().deleteAll(objects);
        }
    }

    /**
     * {@inheritDoc}
     */
    public List searchEquals(Class clazz, final String[] criteria, final String[] properties,
            final RequestOptions requestOptions) {
        return this.search(clazz, criteria, properties, requestOptions,
                HibernateQueryHelper.PREDICATE_EQUALS);
    }

    /**
     * {@inheritDoc}
     */
    public List searchLike(Class clazz, final String[] criteria, final String[] properties,
            final RequestOptions requestOptions) {
        return this.search(clazz, criteria, properties, requestOptions,
                HibernateQueryHelper.PREDICATE_LIKE);
    }

    @SuppressWarnings("unchecked")
    private List<?> search(final Class<?> clazz, final String[] criteria,
            final String[] properties, final RequestOptions requestOptions, final String predicate) {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor
                .getInstanceForSessionFactory(getSessionFactory());

        ISearch search = HibernateQueryHelper.createSearchContext(clazz, criteria, properties,
                requestOptions, predicate);

        return searchProcessor.search(getSession(), search);
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("unchecked")
    public List search(Class clazz, IMutableSearch search) {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor
                .getInstanceForSessionFactory(getSessionFactory());
        search.setSearchClass(clazz);
        return searchProcessor.search(getSession(), search);
    }

    /**
     * {@inheritDoc}
     */
    public int count(Class clazz, IMutableSearch search) {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor
                .getInstanceForSessionFactory(getSessionFactory());
        search.setSearchClass(clazz);
        return searchProcessor.count(getSession(), search);
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("unchecked")
    public SearchResult searchAndCount(Class clazz, IMutableSearch search) {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor
                .getInstanceForSessionFactory(getSessionFactory());
        search.setSearchClass(clazz);
        return searchProcessor.searchAndCount(getSession(), search);
    }

    /**
     * {@inheritDoc}
     */
    public Object searchUnique(Class clazz, IMutableSearch search) throws NonUniqueResultException {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor
                .getInstanceForSessionFactory(getSessionFactory());
        search.setSearchClass(clazz);
        return searchProcessor.searchUnique(getSession(), search);
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("unchecked")
    public boolean exists(Class clazz, Serializable id) {
        Object entity = super.getHibernateTemplate().get(clazz, id);
        return entity != null;
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("unchecked")
    public List findByNamedQuery(String queryName, Map<String, Object> queryParams) {
        String[] params = new String[queryParams.size()];
        Object[] values = new Object[queryParams.size()];
        int index = 0;
        Iterator<String> i = queryParams.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next();
            params[index] = key;
            values[index++] = queryParams.get(key);
        }
        return getHibernateTemplate().findByNamedQueryAndNamedParam(queryName, params, values);
    }

    /**
     * {@inheritDoc}
     */
    public Object merge(Object o) {
        getHibernateTemplate().merge(o);
        return o;
    }

    /**
     * {@inheritDoc}
     */
    public Object persist(Object o) {
        getHibernateTemplate().persist(o);
        return o;
    }

    public Object saveOnly(Object o) {
        getHibernateTemplate().save(o);
        return o;
    }

    public Object updateOnly(Object o) {
        getHibernateTemplate().update(o);
        return o;
    }

}
