/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * EndpointDAO.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.dao.deployment;

import java.util.List;

import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.dao.GenericORMDAO;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
public interface EndpointDAO extends GenericORMDAO<Endpoint, String> {

    /**
     * Retrieve the endpoint that have the given name and which is part of the
     * given technical service.
     * 
     * @param serviceName
     *            a technical service full name
     * @param endpointName
     *            an endpoint name
     * @return the {@link Endpoint} that have the given name and which is part
     *         of the given {@link TechnicalService}.
     */
    Endpoint getByNameAndServiceFullName(String serviceName, String endpointName);

    /**
     * Retrieve the endpoint that have the given name and which is part of the
     * given technical service.
     * 
     * @param serviceId
     *            a technical service id
     * @param endpointName
     *            an endpoint name
     * @return the {@link Endpoint} that have the given name and which is part
     *         of the given {@link TechnicalService}.
     */
    Endpoint getByNameAndServiceId(String serviceId, String endpointName);
    
    
    /**
     * Retrieve the endpoints from the given serviceID 
     * 
      * @param serviceId
     *            a technical service id
     * @return the {@link Endpoint} list that have the given {@link TechnicalService}.
     */
    List<Endpoint> getAllEndpoints(String serviceId);

}
