/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * EndpointDAOImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.dao.deployment.hibernate;

import java.util.List;

import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.dao.GenericHibernateDAOImpl;
import org.ow2.dragon.persistence.dao.deployment.EndpointDAO;

import com.trg.search.Filter;
import com.trg.search.Search;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
public class EndpointDAOImpl extends GenericHibernateDAOImpl<Endpoint, String> implements
        EndpointDAO {

    public Endpoint getByNameAndServiceFullName(String serviceName, String endpointName) {
        Search search = new Search();
        search.addFilter(Filter.and(Filter.equal("name", endpointName), Filter.equal(
                "technicalService.fullName", serviceName)));
        return searchUnique(search);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.persistence.dao.deployment.EndpointDAO#getByNameAndServiceId
     * (java.lang.String, java.lang.String)
     */
    @Override
    public Endpoint getByNameAndServiceId(String serviceId, String endpointName) {
        Search search = new Search();
        search.addFilter(Filter.and(Filter.equal("name", endpointName), Filter.equal(
                "technicalService.id", serviceId)));
        return searchUnique(search);
    }

    @Override
    public List<Endpoint> getAllEndpoints(String serviceId) {
        List<Endpoint> endpoints = this.searchEquals(
                new String[] { serviceId }, new String[] { "technicalService.id" },
                null);
        return endpoints;
    }

}
