/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * SimpleFileDAOImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.dao.metadata.hibernate;

import java.util.List;

import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.persistence.dao.GenericHibernateDAOImpl;
import org.ow2.dragon.persistence.dao.RequestOptions;
import org.ow2.dragon.persistence.dao.metadata.SimpleFileDAO;
import org.ow2.dragon.persistence.util.HibernateQueryHelper;

import com.trg.search.Filter;
import com.trg.search.ISearch;
import com.trg.search.Search;
import com.trg.search.Sort;
import com.trg.search.hibernate.HibernateSearchProcessor;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
public class SimpleFileDAOImpl extends GenericHibernateDAOImpl<SimpleFile, String> implements
        SimpleFileDAO {

    /********
     * 
     */
    public List<SimpleFile> searchEquals(final String[] criteria, final String[] properties,
            final RequestOptions requestOptions) {
        return this.search(criteria, properties, requestOptions,
                HibernateQueryHelper.PREDICATE_EQUALS);
    }

    public List<SimpleFile> searchLike(final String[] criteria, final String[] properties,
            final RequestOptions requestOptions) {
        return this.search(criteria, properties, requestOptions,
                HibernateQueryHelper.PREDICATE_LIKE);
    }
    
    @SuppressWarnings("unchecked")
    private List<SimpleFile> search(final String[] criteria, final String[] properties,
            final RequestOptions requestOptions, final String predicate) {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor
                .getInstanceForSessionFactory(getSessionFactory());

        ISearch search = createSearchContext(this.type, criteria, properties,
                requestOptions, predicate);

        return searchProcessor.search(getSession(), search);
    }
    
    private static ISearch createSearchContext(Class<?> clazz, String[] criterii,
            String[] properties, RequestOptions requestOptions, String predicate) {
        Search search = new Search();
        search.setSearchClass(clazz);
        search.setDistinct(false);

        // Filter on criteria and properties
        if ((criterii != null) && (properties != null) && (criterii.length > 0)
                && (properties.length > 0)) {
            for (String criteria : criterii) {
                Filter filter = Filter.or();
                for (String property : properties) {
                    if (HibernateQueryHelper.PREDICATE_EQUALS.equalsIgnoreCase(predicate)) {
                        if (requestOptions != null && requestOptions.isCaseSensitive()) {
                            filter.add(Filter.equal(property, criteria));
                        } else {
                            filter.add(Filter.iequal(property, criteria));
                        }
                    } else if (HibernateQueryHelper.PREDICATE_LIKE.equalsIgnoreCase(predicate)) {
                        if (requestOptions != null && requestOptions.isCaseSensitive()) {
                            filter.add(Filter.like(property, HibernateQueryHelper.WILDCARD
                                    + criteria + HibernateQueryHelper.WILDCARD));
                        } else {
                            filter.add(Filter.ilike(property, HibernateQueryHelper.WILDCARD
                                    + criteria + HibernateQueryHelper.WILDCARD));
                        }
                    }
                }
                search.addFilterAnd(filter);
            }
        }

        if (requestOptions != null) {
            // Set Paging
            if (requestOptions.hasPagination()) {
                search.setFirstResult(requestOptions.getFirstResult());
                search.setMaxResults(requestOptions.getNbOfResults());
            }

            // Set Sort
            if (requestOptions.hasSortOption()) {
                Sort sort = new Sort();
                sort.setProperty(requestOptions.getSortCriteria());
                if (requestOptions.isSortAscendingly()) {
                    sort.setDesc(false);
                } else {
                    sort.setDesc(true);
                }
                search.addSort(sort);
            }

            // Set Fetch
            if (requestOptions.hasFetchOption()) {
                search.addFetch(requestOptions.getFetchCriteria());
            }
        }

        return search;
    }
    
}
