/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * AgreementDAOImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.dao.sla.hibernate;

import java.util.List;

import org.ow2.dragon.persistence.bo.sla.ManagedAgreement;
import org.ow2.dragon.persistence.dao.GenericHibernateDAOImpl;
import org.ow2.dragon.persistence.dao.sla.ManagedAgreementDAO;

/**
 * @author nsalatge - eBM WebSourcing
 *
 */
public class ManagedAgreementDAOImpl extends GenericHibernateDAOImpl<ManagedAgreement, String> implements ManagedAgreementDAO {

    @Override
    public List<ManagedAgreement> getAllAgreementsFromEndpoint(String endpointId) {
        List<ManagedAgreement> managedAgreement = this.searchEquals(
                new String[] { endpointId }, new String[] { "endpoint.id" },
                null);
        return managedAgreement;
    }

}
