/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * TransfertObjectAssembler.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service;

import java.util.List;

import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.common.CategoryTO;
import org.ow2.dragon.api.to.common.CategoryValueTO;
import org.ow2.dragon.api.to.common.IdentifierTO;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.deployment.BindingOperationTO;
import org.ow2.dragon.api.to.deployment.BindingTO;
import org.ow2.dragon.api.to.deployment.CommentTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.deployment.ProtocolTO;
import org.ow2.dragon.api.to.deployment.RatingTO;
import org.ow2.dragon.api.to.deployment.TechnicalServiceTO;
import org.ow2.dragon.api.to.deployment.TransportTO;
import org.ow2.dragon.api.to.metadata.SimpleFileTO;
import org.ow2.dragon.api.to.organization.OrganizationUnitTO;
import org.ow2.dragon.api.to.organization.PersonTO;
import org.ow2.dragon.api.to.organization.PostTO;
import org.ow2.dragon.api.to.specification.ServiceInterfaceTO;
import org.ow2.dragon.api.to.specification.ServiceSpecificationTO;
import org.ow2.dragon.api.to.wsdm.QoSMetricTO;
import org.ow2.dragon.persistence.bo.common.Category;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.CategoryValue;
import org.ow2.dragon.persistence.bo.common.Comment;
import org.ow2.dragon.persistence.bo.common.Identifier;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Rating;
import org.ow2.dragon.persistence.bo.deployment.Binding;
import org.ow2.dragon.persistence.bo.deployment.BindingOperation;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.deployment.Protocol;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.deployment.Transport;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Person;
import org.ow2.dragon.persistence.bo.organization.Post;
import org.ow2.dragon.persistence.bo.specification.ServiceInterface;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;
import org.ow2.dragon.persistence.bo.wsdm.QoSMetric;
import org.ow2.dragon.persistence.dao.RequestOptions;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@Transactional(readOnly = true)
public interface TransfertObjectAssembler {
    BindingTO toBindingTO(Binding binding);

    EndpointTO toEndpointTO(Endpoint endpoint, String user);

    void toOrganizationUnitBO(OrganizationUnitTO organizationUnitTO,
            OrganizationUnit organizationUnitBO) throws OrganizationException;

    OrganizationUnitTO toOrganizationUnitTO(OrganizationUnit organizationUnitBO);

    void toPersonBO(PersonTO personTO, Person personBO) throws OrganizationException;

    PersonTO toPersonTO(Person person);

    void toPostBO(PostTO postTO, Post postBO) throws OrganizationException;

    PostTO toPostTO(Post post);

    TransportTO toTransportTO(Transport transport);

    ProtocolTO toProtocolTO(Protocol protocol);

    RequestOptions toPartyRequestOptions(RequestOptionsTO requestOptionsTO);

    RequestOptions toPersonRequestOptions(final RequestOptionsTO requestOptionsTO);

    RequestOptions toPostRequestOptions(final RequestOptionsTO requestOptionsTO);

    RequestOptions toEndpointRequestOptions(final RequestOptionsTO requestOptionsTO);

    RequestOptions toServiceRequestOptions(final RequestOptionsTO requestOptionsTO);

    RequestOptions toAgreementRequestOptions(final RequestOptionsTO requestOptionsTO);

    RequestOptions toExecEnvManRequestOptions(final RequestOptionsTO requestOptionsTO);

    RequestOptions toExecEnvRequestOptions(final RequestOptionsTO requestOptionsTO);

    RequestOptions toFederationRequestOptions(final RequestOptionsTO requestOptionsTO);

    RequestOptions toProcessorRequestOptions(final RequestOptionsTO requestOptionsTO);

    RequestOptions toLinkRequestOptions(final RequestOptionsTO requestOptionsTO);

    ServiceInterfaceTO toServiceInterfaceTO(ServiceInterface serviceInterface);

    void toTechServiceBO(TechnicalServiceTO technicalServiceTO, TechnicalService technicalServiceBO);

    TechnicalServiceTO toTechServiceTO(TechnicalService technicalService, String user);

    ServiceSpecificationTO toServiceSpecTO(final ServiceSpecification serviceSpecification);

    SimpleFileTO toSimpleFileTO(final SimpleFile simpleFile);

    CategoryTO toCategoryTO(Category categoryBO);

    IdentifierTO toIdentifierTO(Identifier identifierBO);

    List<CategoryValueTO> toCategoryValuesTO(List<CategoryValue> valuesBO);

    List<KeyedRefTO> toCategoriesTO(CategoryBag categoryBag);

    List<KeyedRefTO> toIdentifiersTO(List<KeyedReference> identifierBag);

    // Added By TIAR Abderrahmane
    RatingTO toRatingTO(Rating rating);

    void toRatingBO(RatingTO ratingTO, Rating ratingBO);

    void toCommentsBO(final List<CommentTO> commentsTO, final List<Comment> commentsBO);

    List<CommentTO> toCommentsTO(final List<Comment> comments);

    void toEndpointBO(EndpointTO endpointTO, Endpoint endpoint);
    
    
    // for wsdm monitoring
    QoSMetricTO toQoSMetricTO(QoSMetric qoSMetric);

    void toQoSMetricBO(QoSMetricTO qoSMetricTO, QoSMetric qoSMetricBO);
    
    BindingOperationTO toBindingOpTO(final BindingOperation bindingOperation);
}
