/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * RoleManagerImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.administration;

/**
 * @author strino - eBM WebSourcing
 * 
 */

import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.api.service.administration.RoleManager;
import org.ow2.dragon.persistence.bo.administration.Role;
import org.ow2.dragon.persistence.dao.administration.RoleDAO;

public class RoleManagerImpl implements RoleManager {

    private RoleDAO roleDAO;

    public void init() {
        // retrieve all name of roles define in EnumRoles
        for (EnumRoles enumRole : EnumRoles.values()) {
            String name = enumRole.toString();
            createRole(name);
        }
    }

    @CheckAllArgumentsNotNull
    public void createRole(String roleName) {

        // Retrieve if the role already exist
        Role role = this.roleDAO.getRoleByName(roleName);

        if (role == null) {
            role = new Role();
            role.setName(roleName);

            // Insert the role in registry
            this.roleDAO.save(role);
        }
    }

    public void setRoleDAO(RoleDAO roleDAO) {
        this.roleDAO = roleDAO;
    }

}
