/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * RolesAndUsersTransfertObjectAssemblerImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.administration;

import java.util.ArrayList;
import java.util.List;

import org.ow2.dragon.api.to.administration.RoleGroupTO;
import org.ow2.dragon.api.to.administration.RoleTO;
import org.ow2.dragon.api.to.administration.UserTO;
import org.ow2.dragon.api.to.organization.OrganizationUnitTO;
import org.ow2.dragon.api.to.organization.PersonTO;
import org.ow2.dragon.persistence.bo.administration.Role;
import org.ow2.dragon.persistence.bo.administration.RoleGroup;
import org.ow2.dragon.persistence.bo.administration.User;
import org.ow2.dragon.persistence.bo.organization.Person;

/**
 * @author strino - eBM WebSourcing
 * 
 */

public class RolesAndUsersTransfertObjectAssemblerImpl implements
        RolesAndUsersTransfertObjectAssembler {

    public void toRoleGroupBO(RoleGroupTO roleGroupTO, RoleGroup roleGroupBO) {

        List<Role> listRoles = new ArrayList<Role>();

        List<String> list = roleGroupTO.getListRoles();

        // Transform List<String> to List<Role>
        if (list != null) {
            for (String ro : list) {
                String nameRole = ro;
                Role role = new Role();
                role.setName(nameRole);
                listRoles.add(role);
            }
        }
        // check if the role group id is not null
        if (roleGroupTO.getId() != null) {
            String id = roleGroupTO.getId();
            roleGroupBO.setId(id);
        }

        roleGroupBO.setName(roleGroupTO.getName());
        roleGroupBO.setListRoles(listRoles);
    }

    public List<RoleGroupTO> toAllGroupes(List<RoleGroup> listRolesGroups) {

        List<RoleGroupTO> listRoleGroupsTO = new ArrayList<RoleGroupTO>();

        for (RoleGroup gR : listRolesGroups) {
            RoleGroupTO role = new RoleGroupTO();
            role.setId(gR.getId());
            role.setName(gR.getName());

            List<String> roles = new ArrayList<String>();
            List<Role> listR = gR.getListRoles();

            // Transform List<Role> to List<String>
            if (listR != null) {
                for (Role r : listR) {

                    roles.add(r.getName());
                }
                role.setListRoles(roles);
            }

            listRoleGroupsTO.add(role);
        }

        return listRoleGroupsTO;
    }

    public RoleGroupTO toRoleGroupTO(RoleGroup groupeRoles) {
        RoleGroupTO role = new RoleGroupTO();
        role.setName(groupeRoles.getName());
        role.setId(groupeRoles.getId());

        List<Role> listR = groupeRoles.getListRoles();
        List<String> list = new ArrayList<String>();

        // Transform List<Role> to List<String>
        for (Role r : listR) {
            list.add(r.getName());
        }
        role.setListRoles(list);
        List<User> listU = groupeRoles.getListUser();
        List<UserTO> listUTO = new ArrayList<UserTO>();
        if (listU != null) {
            for (User us : listU) {
                UserTO usTO = new UserTO();
                usTO.setId(us.getId());
                usTO.setName(us.getName());
                listUTO.add(usTO);
            }
            role.setListUsers(listUTO);
        }

        return role;
    }

    public UserTO toUserTO(User user) {
        UserTO userTO = new UserTO();
        if (user != null) {
            userTO.setId(user.getId());
            userTO.setName(user.getName());
            userTO.setPassword(user.getPassword());

            List<RoleGroup> listRoleGroup = user.getListRoleGroup();
            List<RoleGroupTO> listRoleGroupTO = new ArrayList<RoleGroupTO>();

            // Transform Person to PersonTO if not null
            PersonTO pers = new PersonTO();
            if (user.getPerson() != null) {
                String idPers = user.getPerson().getId();

                if (idPers != null) {
                    pers.setId(idPers);
                    String idOrga = user.getPerson().getParentOrganization().getId();
                    if (idOrga != null) {
                        OrganizationUnitTO orga = new OrganizationUnitTO();
                        orga.setId(idOrga);
                        pers.setOrganization(orga);
                    }
                }
                userTO.setPerson(pers);
            }

            // Transform List<RoleGroup> to List<RoleGroupTO>
            List<RoleTO> listRoleTO = new ArrayList<RoleTO>();

            if (listRoleGroup != null) {

                for (RoleGroup rG : listRoleGroup) {
                    RoleGroupTO roleGroupTO = new RoleGroupTO();
                    roleGroupTO.setId(rG.getId());
                    roleGroupTO.setName(rG.getName());
                    List<Role> listRole = rG.getListRoles();
                    for (Role r : listRole) {
                        RoleTO role = new RoleTO();
                        role.setId(r.getId());
                        role.setName(r.getName());
                        listRoleTO.add(role);
                    }

                    listRoleGroupTO.add(roleGroupTO);
                }
            }

            userTO.setListRoleGroup(listRoleGroupTO);
            listRoleTO = toRoleTO(listRoleTO);

            userTO.setListRoles(listRoleTO);
        }
        return userTO;

    }

    private List<RoleTO> toRoleTO(List<RoleTO> listR) {

        for (int i = 0; i < listR.size(); i++) {
            int j = i + 1;
            while (j < listR.size()) {
                if (listR.get(i).getId() == listR.get(j).getId()) {
                    listR.remove(j);
                }

                else {
                    j++;
                }
            }

        }

        return listR;

    }

    public void toUserBO(UserTO userTO, User userBO) {
        // User user = new User();

        if (userTO.getId() != null) {
            userBO.setId(userTO.getId());
        }

        userBO.setName(userTO.getName());
        userBO.setPassword(userTO.getPassword());

        List<RoleGroupTO> listRoleGroupTO = userTO.getListRoleGroup();

        List<RoleGroup> listRoleGroup = new ArrayList<RoleGroup>();

        Person pers = new Person();

        // Transform PersonTO to Person if not null
        if (userTO.getPerson() != null) {
            String idPers = userTO.getPerson().getId();

            if (idPers != null) {
                pers.setId(idPers);
            }
            userBO.setPerson(pers);
        }

        // Transform List<RoleGroupTO> to List<RoleGroup>
        if (listRoleGroupTO != null) {
            for (RoleGroupTO rGTO : listRoleGroupTO) {
                RoleGroup roleGroup = new RoleGroup();
                roleGroup.setId(rGTO.getId());
                roleGroup.setName(rGTO.getName());

                listRoleGroup.add(roleGroup);
            }
        }
        userBO.setListRoleGroup(listRoleGroup);

    }

}
