/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * OrganizationManagerImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.organization;

import java.util.ArrayList;
import java.util.List;

import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.PartyManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.organization.PartyTO;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Party;
import org.ow2.dragon.persistence.bo.organization.Person;
import org.ow2.dragon.persistence.dao.organization.PartyDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
public class PartyManagerImpl implements PartyManager {

    private TransfertObjectAssembler transfertObjectAssembler;

    private PartyDAO partyDAO;

    /*
     * (non-Javadoc)
     * 
     * @seeorg.ow2.dragon.ui.businessdelegate.organization.OrganizationManager#
     * getAllOrganizations(org.ow2.dragon.ui.model.dataaccess.RequestOptions)
     */
    public List<PartyTO> getAllParties(final RequestOptionsTO requestOptionsTO) {
        final List<PartyTO> result = new ArrayList<PartyTO>();
        final List<Party> parties = this.partyDAO.getAll(this.transfertObjectAssembler
                .toPartyRequestOptions(requestOptionsTO));
        if ((parties != null) && !parties.isEmpty()) {
            for (final Party party : parties) {
                if (party instanceof OrganizationUnit) {
                    result.add(this.transfertObjectAssembler
                            .toOrganizationUnitTO(((OrganizationUnit) party)));
                } else if (party instanceof Person) {
                    result.add(this.transfertObjectAssembler.toPersonTO(((Person) party)));
                }

            }
        }
        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @seeorg.ow2.dragon.ui.businessdelegate.organization.OrganizationManager#
     * getOrganization(java.lang.String)
     */
    @CheckAllArgumentsNotNull
    public PartyTO getParty(final String partyId) throws OrganizationException {
        // retrieve organization unit bo
        final Party partyBO = this.partyDAO.get(partyId);

        if (partyBO == null) {
            throw new OrganizationException("No party found for the given id: " + partyId);
        }
        // create organization unit to from bo
        PartyTO partyTO = null;
        if (partyBO instanceof OrganizationUnit) {
            partyTO = this.transfertObjectAssembler
                    .toOrganizationUnitTO((OrganizationUnit) partyBO);
        } else if (partyBO instanceof Person) {
            partyTO = this.transfertObjectAssembler.toPersonTO((Person) partyBO);
        }
        return partyTO;
    }

    /**
     * @return the partyDAO
     */
    public PartyDAO getPartyDAO() {
        return this.partyDAO;
    }

    /**
     * @param partyDAO
     *            the partyDAO to set
     */
    public void setPartyDAO(final PartyDAO partyDAO) {
        this.partyDAO = partyDAO;
    }

    public void setTransfertObjectAssembler(final TransfertObjectAssembler transfertObjectAssembler) {
        this.transfertObjectAssembler = transfertObjectAssembler;
    }

}
