/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * TechnologyTransferObjectAssemblerImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.technology;

import org.ow2.dragon.api.to.technology.EnvironmentFederationTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentManagerTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentTO;
import org.ow2.dragon.api.to.technology.ProcessorTO;
import org.ow2.dragon.persistence.bo.technology.EnvironmentFederation;
import org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment;
import org.ow2.dragon.persistence.bo.technology.ExecutionEnvironmentManager;
import org.ow2.dragon.persistence.bo.technology.Node;
import org.ow2.dragon.persistence.bo.technology.Processor;
import org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment.EEType;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
public class TechnologyTransferObjectAssemblerImpl implements TechnologyTransferObjectAssembler {

    public ExecutionEnvironmentTO toExecutionEnvironmentTO(
            final ExecutionEnvironment executionEnvironmentBO) {
        ExecutionEnvironmentTO executionEnvironmentTO = null;
        if (executionEnvironmentBO != null) {
            executionEnvironmentTO = new ExecutionEnvironmentTO();
            EEType type = executionEnvironmentBO.getEnvType();
            if (type != null) {
                executionEnvironmentTO.setEnvType(type.toString());
            }
            executionEnvironmentTO.setNodeId(executionEnvironmentBO.getId());
            executionEnvironmentTO
                    .setHostProcessorId(retrieveHostProcessorId(executionEnvironmentBO));
            executionEnvironmentTO.setIpv4Address(executionEnvironmentBO.getIpv4Address());
            executionEnvironmentTO.setName(executionEnvironmentBO.getName());
            EnvironmentFederation federation = executionEnvironmentBO.getParentFederation();
            if (federation != null) {
                executionEnvironmentTO.setParentFederationId(federation.getId());
            }
            executionEnvironmentTO
                    .setRoleInFederation(executionEnvironmentBO.getRoleInFederation());
            executionEnvironmentTO.setType(executionEnvironmentBO.getType());
        }
        return executionEnvironmentTO;
    }

    private String retrieveHostProcessorId(ExecutionEnvironment executionEnvironmentBO) {
        String result = null;
        Node host = executionEnvironmentBO.getHostProcessor();

        if (host != null) {
            result = host.getId();
        }

        return result;
    }

    public ExecutionEnvironmentManagerTO toExecutionEnvironmentManagerTO(
            ExecutionEnvironmentManager executionEnvironmentManagerBO) {
        ExecutionEnvironmentManagerTO executionEnvironmentManagerTO = null;
        if (executionEnvironmentManagerBO != null) {
            executionEnvironmentManagerTO = new ExecutionEnvironmentManagerTO();
            executionEnvironmentManagerTO.setAddress(executionEnvironmentManagerBO.getAddress());
            executionEnvironmentManagerTO
                    .setExecEnvManagerId(executionEnvironmentManagerBO.getId());
            executionEnvironmentManagerTO.setName(executionEnvironmentManagerBO.getName());
        }
        return executionEnvironmentManagerTO;
    }

    public ProcessorTO toProcessorTO(Processor processorBO) {
        ProcessorTO processorTO = null;
        if (processorBO != null) {
            processorTO = new ProcessorTO();
            processorTO.setIpv4Address(processorBO.getIpv4Address());
            processorTO.setName(processorBO.getName());
            processorTO.setNodeId(processorBO.getId());
            processorTO.setType(processorBO.getType());
        }
        return processorTO;
    }

    public EnvironmentFederationTO toEnvironmentFederationTO(
            EnvironmentFederation environmentFederationBO) {
        EnvironmentFederationTO environmentFederationTO = null;
        if (environmentFederationBO != null) {
            environmentFederationTO = new EnvironmentFederationTO();
            environmentFederationTO.setPattern(environmentFederationBO.getPattern().toString());
            environmentFederationTO.setEnvFedId(environmentFederationBO.getId());
            environmentFederationTO.setName(environmentFederationBO.getName());
        }
        return environmentFederationTO;
    }

}
