/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * EasyWSDLTimeout.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.wsdl.importreport;

import java.net.URI;
import java.util.Map;

import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.wsdl.WSDLServiceException;
import org.ow2.dragon.util.AbstractTimeout;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.xml.sax.InputSource;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
public class EasyWSDLTimeout extends AbstractTimeout<WSDLImportReport> {

    private Logger logger = Logger.getLogger(this.getClass());

    private WSDLReader reader;

    InputSource wsdlSource;

    Map<URI, AbsItfDescription> importedWsdls;

    Map<URI, AbsItfSchema> importedSchemas;

    /**
     * {@inheritDoc}
     */
    @Override
    protected WSDLImportReport command() {
        WSDLImportReport result = new WSDLImportReport();
        try {
            result.setResult(this.reader.read(wsdlSource, importedWsdls, importedSchemas));
        } catch (Throwable e) {
            result.setError(new WSDLServiceException(
                    "Can't parse wsdl content. Check the wsdl validity.", e));
        }
        return result;
    }

    public EasyWSDLTimeout(WSDLReader reader, InputSource wsdlSource,
            Map<URI, AbsItfDescription> importedWsdls, Map<URI, AbsItfSchema> importedSchemas) {
        super();
        this.reader = reader;
        this.wsdlSource = wsdlSource;
        this.importedSchemas = importedSchemas;
        this.importedWsdls = importedWsdls;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void commandTimeOut(WSDLImportReport result) {
        // TODO Auto-generated method stub

    }

}
