/**
 * Petals Master - SOA Governance Platform.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * RegisteredWsdlEntities.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.wsdl.importreport;

import java.util.ArrayList;
import java.util.List;

/**
 * @author ofabre
 * 
 */
public class WsdlEntitiesImportReport {

    /**
     * List of imported services (with imported endpoints included)
     */
    private final List<ImportedService> importedServices;

    /**
     * Id of the registered specification
     */
    private String serviceSpecId;

    public void addImportedService(ImportedService importedService) {
        importedServices.add(importedService);
    }

    /**
     * 
     */
    public WsdlEntitiesImportReport() {
        super();
        importedServices = new ArrayList<ImportedService>();
    }

    /**
     * @return the serviceSpecId
     */
    public String getServiceSpecId() {
        return serviceSpecId;
    }

    /**
     * @param serviceSpecId
     *            the serviceSpecId to set
     */
    public void setServiceSpecId(String serviceSpecId) {
        this.serviceSpecId = serviceSpecId;
    }

    /**
     * @return the importedServices
     */
    public List<ImportedService> getImportedServices() {
        return importedServices;
    }

}
