/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * SAAJHelper.java
 * -------------------------------------------------------------------------
 */
package org.ow2.dragon.service.wsdm;

import java.util.UUID;

import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

import org.apache.log4j.Logger;
import org.ow2.easywsdl.schema.api.XmlException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationWriter;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;

/**
 * @author aruffie - eBM Websourcing
 *
 */
public class SAAJHelper {

    private static MessageFactory messageFactory;
    private static Logger logger = Logger.getLogger(SAAJHelper.class);
    static {
        try {
            messageFactory = MessageFactory.newInstance();
        } catch (final SOAPException e) {
            logger.error(e.getMessage());
        }
    }
    private SAAJHelper(){
        //Nop
    }
    
    public static SOAPMessage createSubscribeSOAPMessage(final String subscriptionAddress) throws SOAPException, XmlException{
        final SOAPMessage message = messageFactory.createMessage();
        final SOAPPart part = message.getSOAPPart();
        final SOAPEnvelope envelope = part.getEnvelope();
        final SOAPBody body = envelope.getBody();
        final Subscribe subscribe = createSubscribe(subscriptionAddress);
        final Document subscribeDocument = WSNotificationWriter.getInstance().writeSubscribe(subscribe);
        body.addDocument(subscribeDocument);
        return message;
    }
    
    private static Subscribe createSubscribe(final String subscriptionAddress) throws XmlException{
        final WSNotificationFactory factory = WSNotificationFactory.getInstance();
        final Subscribe subscribe = factory.createSubscribe();
        final com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.FilterType filterType = factory.createFiltertype();
        final EndpointReferenceType endpointReferenceType = WSAddressingFactory.getInstance().newEndpointReferenceType();
        final TopicExpressionType topicExpressionType = factory.createTopicExpressionType();
        topicExpressionType.setDialect("http://www.w3.org/TR/1999/REC-xpath-19991116");
        topicExpressionType.setContent("mows-ev:MetricsCapability");
        topicExpressionType.addTopicNameSpace("mows-ev", "http://docs.oasis-open.org/wsdm/2004/12/mows/wsdm-mows-events.xml");
        endpointReferenceType.setAddress(subscriptionAddress);
        filterType.setTopicExpression(topicExpressionType);
        subscribe.setFilter(filterType);
        subscribe.setConsumerReference(endpointReferenceType);
        return subscribe;
    }

    public static String extractResourcesUuidType(final SOAPMessage response) throws WSNotificationException, SOAPException, WSNotificationExtensionException, WSAddressingException {
        final SOAPPart part = response.getSOAPPart();
        final SOAPEnvelope envelope = part.getEnvelope();
        final SOAPBody body = envelope.getBody();

        
        final NodeList list = body.getChildNodes();
        for(int i = 0 ; i < list.getLength() ;i ++){
            final Node node = list.item(i);
            if("ResourceUuidList".equals(node.getLocalName())&&"http://www.ebmwebsourcing.com/wsnotification/specificTypes".equals(node.getNamespaceURI())){
                return node.getTextContent();
            } else {
                final Node seekedNode = searchNode(node.getChildNodes(),"ResourceUuidList","http://www.ebmwebsourcing.com/wsnotification/specificTypes");
                if(seekedNode != null){
                    return seekedNode.getTextContent();
                }
            }
        }return null;
    }

    public static SOAPMessage createUnSubscribeSOAPMessage(final String endpointRefAddress, final String resourcesUuidType) throws WSNotificationException, SOAPException, WSAddressingException, WSNotificationExtensionException {
        final SOAPMessage message = messageFactory.createMessage();
        final SOAPPart part = message.getSOAPPart();
        final SOAPEnvelope envelope = part.getEnvelope();
        final SOAPBody body = envelope.getBody();
        final Unsubscribe unSubscribe = createUnSubscribe(endpointRefAddress,resourcesUuidType);
        final Document unSubscribeDocument = WSNotificationWriter.getInstance().writeUnsubscribe(unSubscribe);
        body.addDocument(unSubscribeDocument);
        return message;
    }

    private static Unsubscribe createUnSubscribe(final String endpointRefAddress, final String resourcesUuidType) throws WSAddressingException, WSNotificationException, WSNotificationExtensionException {
        final Unsubscribe unsubscribePayload = WSNotificationFactory.getInstance().createUnsubscribe();
        final EndpointReferenceType edpRef = 
            WSAddressingFactory.getInstance().newEndpointReferenceType();
        
        edpRef.setAddress(endpointRefAddress);
        WsnSpecificTypeHelper.setEndpointReference(edpRef, unsubscribePayload);
        
        final ResourcesUuidType uuidsToRemove = WSNotificationExtensionFactory.getInstance().createResourcesUuidType();
        uuidsToRemove.addUuid("uuid:"+UUID.randomUUID());
        
        WsnSpecificTypeHelper.setResourcesUuidType(uuidsToRemove, unsubscribePayload);
        return unsubscribePayload;
    }
    
    private static Node searchNode(final NodeList list, final String localName, final String namespaceURI){
        for(int i = 0 ; i < list.getLength() ; i++){
            final Node node = list.item(i);
            if(localName.equals(node.getLocalName())&&namespaceURI.equals(node.getNamespaceURI())){
                return node;
            }
            final NodeList subList = node.getChildNodes();
            if(subList != null && subList.getLength() > 0){
                final Node seekedNode = searchNode(subList, localName, namespaceURI);
                if(seekedNode != null){
                    return seekedNode;
                }
            }
        }
        return null;
    }

    public static SOAPMessage createGetCurrentMessageSOAPMessage() throws SOAPException {
        final SOAPMessage message = messageFactory.createMessage();
        final SOAPPart part = message.getSOAPPart();
        final SOAPEnvelope envelope = part.getEnvelope();
        final SOAPBody body = envelope.getBody();
        final GetCurrentMessage getCurrentMessage = createGetCurrentMessage();
        return message;
    }

    private static GetCurrentMessage createGetCurrentMessage() {
        final GetCurrentMessage getCurrentMessage = null;
        return getCurrentMessage;
    }
}

