/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.administration;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.ow2.dragon.persistence.bo.administration.Role;
import org.ow2.dragon.persistence.bo.administration.User;
import org.ow2.dragon.persistence.bo.common.NonSearchableBaseObject;

@Entity(name="org.ow2.dragon.persistence.bo.administration.RoleGroup")
public class RoleGroup
extends NonSearchableBaseObject {
    private static final long serialVersionUID = 9115922129178651641L;
    private String name;
    private List<Role> listRoles;
    private List<User> listUser = new ArrayList<User>();

    @Column(unique=true, nullable=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    public List<Role> getListRoles() {
        return this.listRoles;
    }

    public void setListRoles(List<Role> listRoles) {
        this.listRoles = listRoles;
    }

    @ManyToMany(fetch=FetchType.LAZY, mappedBy="listRoleGroup")
    public List<User> getListUser() {
        return this.listUser;
    }

    public void setListUser(List<User> listUser) {
        this.listUser = listUser;
    }

    public void addRole(Role role) {
        this.getListRoles().add(role);
    }

    public void removeRole(Role role) {
        this.getListRoles().remove(role);
    }

    public void addUser(User user) {
        this.getListUser().add(user);
        user.getListRoleGroup().add(this);
    }

    public void removeUser(User user) {
        this.getListUser().remove(user);
        user.getListRoleGroup().remove(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof RoleGroup)) {
            return false;
        }
        RoleGroup castOther = (RoleGroup)other;
        return new EqualsBuilder().append((Object)this.name, (Object)castOther.name).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("id", (Object)this.name).toString();
    }
}

