/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.administration;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.ow2.dragon.persistence.bo.administration.RoleGroup;
import org.ow2.dragon.persistence.bo.common.NonSearchableBaseObject;
import org.ow2.dragon.persistence.bo.organization.Person;

@Entity(name="org.ow2.dragon.persistence.bo.administration.User")
@Table(name="MasterUser")
public class User
extends NonSearchableBaseObject {
    private static final long serialVersionUID = -6979069718270125935L;
    private String name;
    private String password;
    private List<RoleGroup> listRoleGroup = new ArrayList<RoleGroup>();
    private Person person;

    @Column(unique=true, nullable=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(nullable=false)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    public List<RoleGroup> getListRoleGroup() {
        return this.listRoleGroup;
    }

    public void setListRoleGroup(List<RoleGroup> listRoleGroup) {
        this.listRoleGroup = listRoleGroup;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public void addRoleGroup(RoleGroup roleGroup) {
        this.getListRoleGroup().add(roleGroup);
        roleGroup.getListUser().add(this);
    }

    public void removeRoleGroup(RoleGroup roleGroup) {
        this.getListRoleGroup().remove(roleGroup);
        roleGroup.getListUser().remove(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof User)) {
            return false;
        }
        User castOther = (User)other;
        return new EqualsBuilder().append((Object)this.name, (Object)castOther.name).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("id", (Object)this.name).toString();
    }
}

