/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.common;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.ow2.dragon.persistence.bo.common.Link;
import org.ow2.dragon.persistence.bo.common.SearchableBaseObject;

@Entity(name="org.ow2.dragon.persistence.bo.common.LinkedEntity")
@Inheritance(strategy=InheritanceType.JOINED)
@Searchable(root=false)
public class LinkedEntity
extends SearchableBaseObject {
    private static final long serialVersionUID = -7684972596407987657L;
    @SearchableComponent(maxDepth=2)
    private Set<Link> fromLinks = new HashSet<Link>();
    @SearchableComponent(maxDepth=2)
    private Set<Link> toLinks = new HashSet<Link>();

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof LinkedEntity)) {
            return false;
        }
        LinkedEntity castOther = (LinkedEntity)other;
        return new EqualsBuilder().append(this.fromLinks, castOther.fromLinks).append(this.toLinks, castOther.toLinks).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.fromLinks).append(this.toLinks).toHashCode();
    }

    public void addFromLink(Link link) {
        this.getFromLinks().add(link);
        link.setFrom(this);
    }

    public void addToLink(Link link) {
        this.getToLinks().add(link);
        link.setTo(this);
    }

    public void removeFromLink(Link link) {
        this.getFromLinks().remove(link);
        link.setFrom(null);
    }

    public void removeToLink(Link link) {
        this.getToLinks().remove(link);
        link.setTo(null);
    }

    @OneToMany(cascade={CascadeType.REMOVE}, mappedBy="from")
    public Set<Link> getFromLinks() {
        return this.fromLinks;
    }

    public void setFromLinks(Set<Link> fromLinks) {
        this.fromLinks = fromLinks;
    }

    @OneToMany(cascade={CascadeType.REMOVE}, mappedBy="to")
    public Set<Link> getToLinks() {
        return this.toLinks;
    }

    public void setToLinks(Set<Link> toLinks) {
        this.toLinks = toLinks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("fromLinks", this.fromLinks).append("toLinks", this.toLinks).toString();
    }
}

