/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.deployment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.hibernate.annotations.Cascade;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.CommunityObj;
import org.ow2.dragon.persistence.bo.common.Description;
import org.ow2.dragon.persistence.bo.deployment.Binding;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;
import org.ow2.dragon.persistence.bo.technology.Node;

@Entity(name="org.ow2.dragon.persistence.bo.deployment.Endpoint")
@Searchable(root=false)
public class Endpoint
extends CommunityObj
implements Comparable<Endpoint> {
    private static final long serialVersionUID = -2024620472026451233L;
    @SearchableComponent
    private Binding binding;
    private String name;
    private String networkAddress;
    private TechnicalService technicalService;
    private Set<ServiceSpecification> serviceSpecifications;
    private Node hostNode;
    private boolean wsdmMonitoring = true;
    private boolean subscription;
    private String subscriptionAddr;
    private String resourcesUuidType;
    @SearchableComponent
    private List<Description> descriptions = new ArrayList<Description>();
    @SearchableComponent
    private CategoryBag categoryBag;

    public Endpoint() {
        this.serviceSpecifications = new HashSet<ServiceSpecification>();
    }

    public void addDescription(Description description) {
        this.getDescriptions().add(description);
    }

    public void addServiceSpec(ServiceSpecification serviceSpecification) {
        this.getServiceSpecifications().add(serviceSpecification);
        serviceSpecification.getEndpoints().add(this);
    }

    public void removeServiceSpec(ServiceSpecification serviceSpecification) {
        this.getServiceSpecifications().remove(serviceSpecification);
        serviceSpecification.getEndpoints().remove(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Endpoint)) {
            return false;
        }
        Endpoint castOther = (Endpoint)other;
        return new EqualsBuilder().append((Object)this.name, (Object)castOther.name).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).toHashCode();
    }

    @ManyToOne
    @JoinColumn(name="nodeId")
    public Node getHostNode() {
        return this.hostNode;
    }

    public void setHostNode(Node hostNode) {
        this.hostNode = hostNode;
    }

    @ManyToOne
    @JoinColumn(name="bindingId")
    public Binding getBinding() {
        return this.binding;
    }

    public String getName() {
        return this.name;
    }

    public String getNetworkAddress() {
        return this.networkAddress;
    }

    @ManyToOne
    @JoinColumn(name="technicalServiceId", nullable=false)
    public TechnicalService getTechnicalService() {
        return this.technicalService;
    }

    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNetworkAddress(String networkAddress) {
        this.networkAddress = networkAddress;
    }

    public void setTechnicalService(TechnicalService technicalService) {
        this.technicalService = technicalService;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("networkAddress", (Object)this.networkAddress).append("binding", (Object)this.binding).append("name", (Object)this.name).toString();
    }

    @Override
    public int compareTo(Endpoint other) {
        return new CompareToBuilder().append((Object)this.name, (Object)other.name).toComparison();
    }

    @OneToMany(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<Description> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<Description> descriptions) {
        this.descriptions = descriptions;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public CategoryBag getCategoryBag() {
        return this.categoryBag;
    }

    public void setCategoryBag(CategoryBag categoryBag) {
        this.categoryBag = categoryBag;
    }

    @ManyToMany(mappedBy="endpoints")
    public Set<ServiceSpecification> getServiceSpecifications() {
        return this.serviceSpecifications;
    }

    public void setServiceSpecifications(Set<ServiceSpecification> serviceSpecifications) {
        this.serviceSpecifications = serviceSpecifications;
    }

    public boolean isWsdmMonitoring() {
        return this.wsdmMonitoring;
    }

    public void setWsdmMonitoring(boolean wsdmMonitoring) {
        this.wsdmMonitoring = wsdmMonitoring;
    }

    public boolean isSubscription() {
        return this.subscription;
    }

    public void setSubscription(boolean subscription) {
        this.subscription = subscription;
    }

    public String getSubscriptionAddr() {
        return this.subscriptionAddr;
    }

    public void setSubscriptionAddr(String subscriptionAddr) {
        this.subscriptionAddr = subscriptionAddr;
    }

    public String getResourcesUuidType() {
        return this.resourcesUuidType;
    }

    public void setResourcesUuidType(String resourcesUuidType) {
        this.resourcesUuidType = resourcesUuidType;
    }
}

