/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.specification;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.ow2.dragon.persistence.bo.deployment.Binding;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.specification.ServiceInterface;
import org.ow2.dragon.persistence.bo.specification.VersionedSpecification;

@Entity(name="org.ow2.dragon.persistence.bo.specification.ServiceSpecification")
@Inheritance(strategy=InheritanceType.JOINED)
public class ServiceSpecification
extends VersionedSpecification {
    private static final long serialVersionUID = -720509434728670906L;
    private String wsdlSha1;
    private Set<Binding> bindings;
    private Set<ServiceInterface> serviceInterfaces = new HashSet<ServiceInterface>();
    private Set<TechnicalService> technicalServices = new HashSet<TechnicalService>();
    private Set<Endpoint> endpoints = new HashSet<Endpoint>();

    public ServiceSpecification() {
        this.bindings = new HashSet<Binding>();
    }

    public void addBinding(Binding binding) {
        this.getBindings().add(binding);
        binding.getServiceSpecifications().add(this);
    }

    public void addEndpoint(Endpoint endpoint) {
        this.getEndpoints().add(endpoint);
        endpoint.getServiceSpecifications().add(this);
    }

    public void removeEndpoint(Endpoint endpoint) {
        this.getEndpoints().remove(endpoint);
        endpoint.getServiceSpecifications().remove(this);
    }

    public void addServiceInterface(ServiceInterface serviceInterface) {
        this.getServiceInterfaces().add(serviceInterface);
        serviceInterface.getServiceSpecs().add(this);
    }

    public void addTechnicalService(TechnicalService technicalService) {
        this.getTechnicalServices().add(technicalService);
        technicalService.getServiceSpecifications().add(this);
    }

    public void removeTechnicalService(TechnicalService technicalService) {
        this.getTechnicalServices().remove(technicalService);
        technicalService.getServiceSpecifications().remove(this);
    }

    @ManyToMany
    public Set<Binding> getBindings() {
        return this.bindings;
    }

    @ManyToMany
    @JoinTable(name="ServSpec_ServInterface")
    public Set<ServiceInterface> getServiceInterfaces() {
        return this.serviceInterfaces;
    }

    @ManyToMany
    @JoinTable(name="ServSpec_TechServ")
    public Set<TechnicalService> getTechnicalServices() {
        return this.technicalServices;
    }

    public void setBindings(Set<Binding> bindings) {
        this.bindings = bindings;
    }

    public void setServiceInterfaces(Set<ServiceInterface> serviceInterfaces) {
        this.serviceInterfaces = serviceInterfaces;
    }

    public void setTechnicalServices(Set<TechnicalService> technicalServices) {
        this.technicalServices = technicalServices;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("bindings", this.bindings).append("serviceInterfaces", this.serviceInterfaces).append("technicalServices", this.technicalServices).toString();
    }

    public String getWsdlSha1() {
        return this.wsdlSha1;
    }

    public void setWsdlSha1(String wsdlSha1) {
        this.wsdlSha1 = wsdlSha1;
    }

    @ManyToMany
    public Set<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(Set<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }
}

