/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.technology;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableProperty;
import org.hibernate.annotations.CollectionOfElements;
import org.ow2.dragon.persistence.bo.common.SearchableBaseObject;
import org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment;

@Entity(name="org.ow2.dragon.persistence.bo.technology.EnvironmentFederation")
@Searchable
public class EnvironmentFederation
extends SearchableBaseObject {
    private static final long serialVersionUID = 357424309465096843L;
    private String name;
    private FedPattern pattern;
    private List<String> possibleRole;
    private Set<ExecutionEnvironment> execEnvs = new HashSet<ExecutionEnvironment>();

    public EnvironmentFederation() {
        this.possibleRole = new ArrayList<String>();
    }

    public void addExecEnv(ExecutionEnvironment executionEnvironment) {
        this.execEnvs.add(executionEnvironment);
        executionEnvironment.setParentFederation(this);
    }

    public void addPossibleRole(String possibleRole) {
        this.possibleRole.add(possibleRole);
    }

    public void removeExecEnv(ExecutionEnvironment executionEnvironment) {
        this.getExecEnvs().remove(executionEnvironment);
        executionEnvironment.setParentFederation(null);
    }

    @OneToMany(mappedBy="parentFederation")
    public Set<ExecutionEnvironment> getExecEnvs() {
        return this.execEnvs;
    }

    public void setExecEnvs(Set<ExecutionEnvironment> execEnvs) {
        this.execEnvs = execEnvs;
    }

    @SearchableProperty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Enumerated(value=EnumType.STRING)
    @SearchableProperty
    public FedPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(FedPattern pattern) {
        this.pattern = pattern;
    }

    @CollectionOfElements
    @JoinTable(name="EnvFede_possibleRole")
    public List<String> getPossibleRole() {
        return this.possibleRole;
    }

    public void setPossibleRole(List<String> possibleRole) {
        this.possibleRole = possibleRole;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof EnvironmentFederation)) {
            return false;
        }
        EnvironmentFederation castOther = (EnvironmentFederation)other;
        return new EqualsBuilder().append((Object)this.name, (Object)castOther.name).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("execEnvs", this.execEnvs).append("pattern", (Object)this.pattern).append("possibleRole", this.possibleRole).append("name", (Object)this.name).toString();
    }

    public static enum FedPattern {
        HUB_AND_SPOKE,
        FEDERATED,
        GRID,
        DISTRIBUTED;

    }
}

