/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.dao;

import com.trg.search.IMutableSearch;
import com.trg.search.SearchResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.NonUniqueResultException;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.aop.annotation.CheckArgumentsNotNull;
import org.ow2.dragon.persistence.bo.common.SearchableBaseObject;
import org.ow2.dragon.persistence.dao.DAOLayerException;
import org.ow2.dragon.persistence.dao.GenericORMDAO;
import org.ow2.dragon.persistence.dao.GenericOSEMDAO;
import org.ow2.dragon.persistence.dao.GenericUnifiedDAO;
import org.ow2.dragon.persistence.dao.RequestOptions;
import org.ow2.dragon.persistence.util.CompassQueryHelper;

public class GenericHibernateCompassDAOImpl<T extends SearchableBaseObject, PK extends Serializable>
implements GenericUnifiedDAO<T, PK> {
    private GenericOSEMDAO<T, PK> genericOSEMDAO;
    private GenericORMDAO<T, PK> genericORMDAO;

    @Override
    public boolean exists(PK id) {
        return this.genericORMDAO.exists(id);
    }

    @Override
    public List<T> findByNamedQuery(String queryName, Map<String, Object> queryParams) {
        return this.genericORMDAO.findByNamedQuery(queryName, queryParams);
    }

    @Override
    public T get(PK id) {
        return (T)((SearchableBaseObject)this.genericORMDAO.get(id));
    }

    @Override
    public List<T> getAll(RequestOptions requestOptionsTO) {
        return this.genericORMDAO.getAll(requestOptionsTO);
    }

    @Override
    public List<T> getAll() {
        return this.genericORMDAO.getAll();
    }

    @Override
    public List<T> getAllDistinct() {
        return this.genericORMDAO.getAllDistinct();
    }

    @Override
    public void remove(PK id) {
        this.genericORMDAO.remove(id);
    }

    @Override
    public T save(T object) {
        return (T)((SearchableBaseObject)this.genericORMDAO.save(object));
    }

    @Override
    public List<T> search(String query) {
        return this.genericOSEMDAO.search(query);
    }

    @Override
    public List<T> searchEquals(String[] criteria, String[] properties, RequestOptions requestOptionsTO) {
        return this.genericORMDAO.searchEquals(criteria, properties, requestOptionsTO);
    }

    @Override
    public List<T> searchLike(String[] criteria, String[] properties, RequestOptions requestOptionsTO) {
        return this.genericORMDAO.searchLike(criteria, properties, requestOptionsTO);
    }

    @Override
    public List<T> searchORMResult(String query) {
        return this.searchORMResult(query, null);
    }

    @Override
    public List<T> searchORMResult(String query, RequestOptions requestOptions) {
        List<T> osemResults = this.search(query);
        ArrayList<String> ids = new ArrayList<String>();
        for (SearchableBaseObject t : osemResults) {
            ids.add(t.getId());
        }
        return this.getAll(ids, requestOptions);
    }

    @Override
    public List<T> getAll(List<PK> ids, RequestOptions requestOptions) {
        return this.genericORMDAO.getAll(ids, requestOptions);
    }

    @Override
    public List<T> getAll(List<PK> ids) {
        return this.getAll(ids, null);
    }

    @Override
    @CheckAllArgumentsNotNull
    public List<T> searchORMResult(String[] criteria, String[] searchedProperties) throws DAOLayerException {
        return this.searchORMResult(criteria, searchedProperties, null);
    }

    @Override
    @CheckArgumentsNotNull
    public List<T> searchORMResult(String[] criteria, String[] searchedProperties, RequestOptions requestOptions) throws DAOLayerException {
        if (criteria.length == 0 || searchedProperties.length == 0) {
            throw new DAOLayerException("Search criterii and properties can't be empty.");
        }
        String query = CompassQueryHelper.decorateQuery(criteria, searchedProperties, this.genericOSEMDAO.getManipulatedType().getSimpleName());
        return this.searchORMResult(query, requestOptions);
    }

    public void setGenericOSEMDAO(GenericOSEMDAO<T, PK> genericOSEMDAO) {
        this.genericOSEMDAO = genericOSEMDAO;
    }

    public void setGenericORMDAO(GenericORMDAO<T, PK> genericORMDAO) {
        this.genericORMDAO = genericORMDAO;
    }

    @Override
    public int count(IMutableSearch search) {
        return this.genericORMDAO.count(search);
    }

    @Override
    public List<T> search(IMutableSearch search) {
        return this.genericORMDAO.search(search);
    }

    @Override
    public SearchResult<T> searchAndCount(IMutableSearch search) {
        return this.genericORMDAO.searchAndCount(search);
    }

    @Override
    public T searchUnique(IMutableSearch search) throws NonUniqueResultException {
        return (T)((SearchableBaseObject)this.genericORMDAO.searchUnique(search));
    }

    protected GenericOSEMDAO<T, PK> getGenericOSEMDAO() {
        return this.genericOSEMDAO;
    }

    protected GenericORMDAO<T, PK> getGenericORMDAO() {
        return this.genericORMDAO;
    }

    @Override
    public void remove(T object) {
        this.genericORMDAO.remove(object);
    }
}

