/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.dao;

import com.trg.search.IMutableSearch;
import com.trg.search.ISearch;
import com.trg.search.Search;
import com.trg.search.SearchResult;
import com.trg.search.hibernate.HibernateSearchProcessor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.NonUniqueResultException;
import org.hibernate.SessionFactory;
import org.ow2.dragon.persistence.dao.GenericORMDAO;
import org.ow2.dragon.persistence.dao.RequestOptions;
import org.ow2.dragon.persistence.util.HibernateQueryHelper;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class GenericHibernateDAOImpl<T, PK extends Serializable>
extends HibernateDaoSupport
implements GenericORMDAO<T, PK> {
    private Logger log = Logger.getLogger(this.getClass());
    public Class<T> type;

    public void setType(Class<T> type) {
        this.type = type;
    }

    @Override
    public List<T> getAll(RequestOptions requestOptions) {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor.getInstanceForSessionFactory((SessionFactory)this.getSessionFactory());
        ISearch search = HibernateQueryHelper.createSearchContext(this.type, null, null, requestOptions, null);
        return searchProcessor.search(this.getSession(), search);
    }

    private List<T> search(String[] criteria, String[] properties, RequestOptions requestOptions, String predicate) {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor.getInstanceForSessionFactory((SessionFactory)this.getSessionFactory());
        ISearch search = HibernateQueryHelper.createSearchContext(this.type, criteria, properties, requestOptions, predicate);
        return searchProcessor.search(this.getSession(), search);
    }

    @Override
    public List<T> searchEquals(String[] criteria, String[] properties, RequestOptions requestOptions) {
        return this.search(criteria, properties, requestOptions, "=");
    }

    @Override
    public List<T> searchLike(String[] criteria, String[] properties, RequestOptions requestOptions) {
        return this.search(criteria, properties, requestOptions, "like");
    }

    @Override
    public List<T> getAll() {
        return super.getHibernateTemplate().loadAll(this.type);
    }

    @Override
    public List<T> getAll(List<PK> ids) {
        return this.getAll(ids, null);
    }

    @Override
    public List<T> getAll(List<PK> ids, RequestOptions requestOptions) {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor.getInstanceForSessionFactory((SessionFactory)this.getSessionFactory());
        Search search = (Search)HibernateQueryHelper.createSearchContext(this.type, null, null, requestOptions, null);
        search.addFilterIn("id", ids);
        return searchProcessor.search(this.getSession(), (ISearch)search);
    }

    @Override
    public List<T> getAllDistinct() {
        LinkedHashSet<T> result = new LinkedHashSet<T>(this.getAll());
        return new ArrayList<T>(result);
    }

    @Override
    public T get(PK id) {
        Object entity = super.getHibernateTemplate().get(this.type, id);
        return (T)entity;
    }

    @Override
    public boolean exists(PK id) {
        Object entity = super.getHibernateTemplate().get(this.type, id);
        return entity != null;
    }

    @Override
    public T save(T object) {
        super.getHibernateTemplate().saveOrUpdate(object);
        return object;
    }

    @Override
    public void remove(PK id) {
        T object = this.get(id);
        if (object != null) {
            super.getHibernateTemplate().delete(object);
        }
    }

    @Override
    public void remove(T object) {
        if (object != null) {
            super.getHibernateTemplate().delete(object);
        }
    }

    @Override
    public List<T> findByNamedQuery(String queryName, Map<String, Object> queryParams) {
        String[] params = new String[queryParams.size()];
        Object[] values = new Object[queryParams.size()];
        int index = 0;
        Iterator<String> i = queryParams.keySet().iterator();
        while (i.hasNext()) {
            String key;
            params[index] = key = i.next();
            values[index++] = queryParams.get(key);
        }
        return this.getHibernateTemplate().findByNamedQueryAndNamedParam(queryName, params, values);
    }

    @Override
    public Class<T> getManipulatedType() {
        return this.type;
    }

    @Override
    public List<T> search(IMutableSearch search) {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor.getInstanceForSessionFactory((SessionFactory)this.getSessionFactory());
        search.setSearchClass(this.type);
        return searchProcessor.search(this.getSession(), (ISearch)search);
    }

    @Override
    public int count(IMutableSearch search) {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor.getInstanceForSessionFactory((SessionFactory)this.getSessionFactory());
        search.setSearchClass(this.type);
        return searchProcessor.count(this.getSession(), (ISearch)search);
    }

    @Override
    public SearchResult<T> searchAndCount(IMutableSearch search) {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor.getInstanceForSessionFactory((SessionFactory)this.getSessionFactory());
        search.setSearchClass(this.type);
        return searchProcessor.searchAndCount(this.getSession(), (ISearch)search);
    }

    @Override
    public T searchUnique(IMutableSearch search) throws NonUniqueResultException {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor.getInstanceForSessionFactory((SessionFactory)this.getSessionFactory());
        search.setSearchClass(this.type);
        return (T)searchProcessor.searchUnique(this.getSession(), (ISearch)search);
    }
}

