/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.administration;

import java.util.ArrayList;
import java.util.List;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.api.service.administration.RoleGroupException;
import org.ow2.dragon.api.service.administration.RoleGroupManager;
import org.ow2.dragon.api.to.administration.RoleGroupTO;
import org.ow2.dragon.persistence.bo.administration.Role;
import org.ow2.dragon.persistence.bo.administration.RoleGroup;
import org.ow2.dragon.persistence.bo.administration.User;
import org.ow2.dragon.persistence.dao.administration.RoleDAO;
import org.ow2.dragon.persistence.dao.administration.RoleGroupDAO;
import org.ow2.dragon.persistence.dao.administration.UserDAO;
import org.ow2.dragon.service.administration.RolesAndUsersTransfertObjectAssembler;
import org.ow2.dragon.util.StringHelper;

public class RoleGroupManagerImpl
implements RoleGroupManager {
    private RolesAndUsersTransfertObjectAssembler rolesAndUsersTransfertObjectAssembler;
    private RoleGroupDAO roleGroupDAO;
    private RoleDAO roleDAO;
    private UserDAO userDAO;

    @Override
    public void init() {
        RoleGroup roleGroupBO = this.roleGroupDAO.getRoleGroupByName("admin");
        if (roleGroupBO == null) {
            RoleGroup roleGroup = new RoleGroup();
            roleGroup.setName("admin");
            List<Role> listRoles = this.roleDAO.getAll();
            roleGroup.setListRoles(listRoles);
            this.roleGroupDAO.save(roleGroup);
        }
    }

    @Override
    @CheckAllArgumentsNotNull
    public String createRoleGroup(RoleGroupTO roleGroupTO) throws RoleGroupException {
        RoleGroup roleGroup = new RoleGroup();
        this.validateBeforeSaveOrUpdate(roleGroupTO, null);
        this.rolesAndUsersTransfertObjectAssembler.toRoleGroupBO(roleGroupTO, roleGroup);
        ArrayList<Role> listR = new ArrayList<Role>();
        List<Role> listRole = roleGroup.getListRoles();
        for (Role ro : listRole) {
            ro = this.roleDAO.getRoleByName(ro.getName());
            listR.add(ro);
        }
        roleGroup.setListRoles(listR);
        return this.roleGroupDAO.save(roleGroup).getId();
    }

    @Override
    public List<RoleGroupTO> getAllRoleGroup() throws RoleGroupException {
        List<RoleGroup> listAllGroupe = this.roleGroupDAO.getAll();
        List<RoleGroupTO> listRole = this.rolesAndUsersTransfertObjectAssembler.toAllGroupes(listAllGroupe);
        return listRole;
    }

    @Override
    @CheckAllArgumentsNotNull
    public List<RoleGroupTO> getRoleGroupNotInUser(String idUser) throws RoleGroupException {
        ArrayList<RoleGroupTO> listRoleGroupTO = new ArrayList<RoleGroupTO>();
        User user = (User)this.userDAO.get(idUser);
        List<Object> listRoleGroupInUser = new ArrayList();
        if (user == null) {
            throw new RoleGroupException("A user with that name doesn't exist ! ");
        }
        listRoleGroupInUser = user.getListRoleGroup();
        List allRoleGroup = this.roleGroupDAO.getAll();
        if (allRoleGroup != null) {
            if (!listRoleGroupInUser.isEmpty()) {
                allRoleGroup.removeAll(listRoleGroupInUser);
            }
            for (RoleGroup rG : allRoleGroup) {
                listRoleGroupTO.add(this.rolesAndUsersTransfertObjectAssembler.toRoleGroupTO(rG));
            }
        } else {
            throw new RoleGroupException("no role groups in database ! ");
        }
        return listRoleGroupTO;
    }

    @Override
    @CheckAllArgumentsNotNull
    public RoleGroupTO getRoleGroup(String idGroup) throws RoleGroupException {
        RoleGroup roleGroup = (RoleGroup)this.roleGroupDAO.get(idGroup);
        if (roleGroup == null) {
            throw new RoleGroupException("no role groups whith this id in database ! ");
        }
        RoleGroupTO role = this.rolesAndUsersTransfertObjectAssembler.toRoleGroupTO(roleGroup);
        return role;
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeRoleGroup(String idGroup) throws RoleGroupException {
        RoleGroup roleGroup = (RoleGroup)this.roleGroupDAO.get(idGroup);
        if (roleGroup == null) {
            throw new RoleGroupException("no role groups whith this id in database ! ");
        }
        this.roleGroupDAO.remove(roleGroup);
    }

    @Override
    @CheckAllArgumentsNotNull
    public String updateRoleGroup(RoleGroupTO roleGroupTO) throws RoleGroupException {
        String id = roleGroupTO.getId();
        if (id == null) {
            throw new RoleGroupException("this role doesn't already exist in database : ");
        }
        RoleGroup group = (RoleGroup)this.roleGroupDAO.get(roleGroupTO.getId());
        if (group == null) {
            throw new RoleGroupException("this role doesn't already exist in database : " + id);
        }
        this.validateBeforeSaveOrUpdate(roleGroupTO, group.getName());
        this.rolesAndUsersTransfertObjectAssembler.toRoleGroupBO(roleGroupTO, group);
        ArrayList<Role> listR = new ArrayList<Role>();
        List<Role> listRole = group.getListRoles();
        for (Role ro : listRole) {
            ro = this.roleDAO.getRoleByName(ro.getName());
            listR.add(ro);
        }
        group.setListRoles(listR);
        this.roleGroupDAO.save(group);
        return group.getId();
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeUser(String idUser, String idRoleGroup) throws RoleGroupException {
        RoleGroup roleGroup = (RoleGroup)this.roleGroupDAO.get(idRoleGroup);
        if (roleGroup == null) {
            throw new RoleGroupException("You are trying to remove a user to a non existing role whit id : " + idRoleGroup);
        }
        User user = (User)this.userDAO.get(idUser);
        if (user == null) {
            throw new RoleGroupException("You are trying to remove a non existing user to a role whith id : " + idRoleGroup);
        }
        roleGroup.removeUser(user);
        this.roleGroupDAO.save(roleGroup);
    }

    @Override
    @CheckAllArgumentsNotNull
    public void addUser(String idUser, String idRoleGroup) throws RoleGroupException {
        RoleGroup roleGroup = (RoleGroup)this.roleGroupDAO.get(idRoleGroup);
        if (roleGroup == null) {
            throw new RoleGroupException("You are trying to add a user to a non existing role whit id : " + idRoleGroup);
        }
        User user = (User)this.userDAO.get(idUser);
        if (user == null) {
            throw new RoleGroupException("You are trying to add a non existing user to a role whith id : " + idRoleGroup);
        }
        roleGroup.addUser(user);
        this.roleGroupDAO.save(roleGroup);
    }

    private void validateBeforeSaveOrUpdate(RoleGroupTO roleGroup, String nameRoleGroup) throws RoleGroupException {
        RoleGroup group;
        String roleGroupNameTO = roleGroup.getName();
        if (StringHelper.isNullOrEmpty((String)roleGroupNameTO)) {
            throw new RoleGroupException("Role Name must be speficied.");
        }
        if (!roleGroupNameTO.equalsIgnoreCase(nameRoleGroup) && (group = this.roleGroupDAO.getRoleGroupByName(roleGroupNameTO)) != null) {
            throw new RoleGroupException("A role with that name already exists : " + roleGroupNameTO);
        }
    }

    public void setRolesAndUsersTransfertObjectAssembler(RolesAndUsersTransfertObjectAssembler rolesAndUsersTransfertObjectAssembler) {
        this.rolesAndUsersTransfertObjectAssembler = rolesAndUsersTransfertObjectAssembler;
    }

    public void setRoleGroupDAO(RoleGroupDAO roleGroupDAO) {
        this.roleGroupDAO = roleGroupDAO;
    }

    public void setRoleDAO(RoleDAO roleDAO) {
        this.roleDAO = roleDAO;
    }

    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }
}

