/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.administration;

import java.util.ArrayList;
import java.util.List;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.api.service.administration.UserException;
import org.ow2.dragon.api.service.administration.UserManager;
import org.ow2.dragon.api.to.administration.UserTO;
import org.ow2.dragon.persistence.bo.administration.RoleGroup;
import org.ow2.dragon.persistence.bo.administration.User;
import org.ow2.dragon.persistence.dao.administration.RoleGroupDAO;
import org.ow2.dragon.persistence.dao.administration.UserDAO;
import org.ow2.dragon.service.administration.RolesAndUsersTransfertObjectAssembler;
import org.ow2.dragon.util.StringHelper;

public class UserManagerImpl
implements UserManager {
    private RolesAndUsersTransfertObjectAssembler rolesAndUsersTransfertObjectAssembler;
    private UserDAO userDAO;
    private RoleGroupDAO roleGroupDAO;

    @Override
    public void init() {
        User userBO = this.userDAO.getUserByName("master");
        if (userBO == null) {
            User user = new User();
            user.setName("master");
            user.setPassword("eb0a191797624dd3a48fa681d3061212");
            RoleGroup roleGroup = this.roleGroupDAO.getRoleGroupByName("admin");
            ArrayList<RoleGroup> listRoleGroup = new ArrayList<RoleGroup>();
            listRoleGroup.add(roleGroup);
            user.setListRoleGroup(listRoleGroup);
            this.userDAO.save(user);
        }
    }

    @Override
    @CheckAllArgumentsNotNull
    public String createUser(UserTO userTO) throws UserException {
        User user = new User();
        this.validateUserBeforSaveOrUpdate(userTO, null);
        this.rolesAndUsersTransfertObjectAssembler.toUserBO(userTO, user);
        return this.userDAO.save(user).getId();
    }

    @Override
    public List<UserTO> getAllUser() throws UserException {
        ArrayList<UserTO> listUserTO = new ArrayList<UserTO>();
        List listUser = this.userDAO.getAll();
        for (User us : listUser) {
            UserTO userTO = this.rolesAndUsersTransfertObjectAssembler.toUserTO(us);
            listUserTO.add(userTO);
        }
        return listUserTO;
    }

    @Override
    @CheckAllArgumentsNotNull
    public List<UserTO> getUserNotInRoleGroup(String idRoleGroup) throws UserException {
        ArrayList<UserTO> listUserTO = new ArrayList<UserTO>();
        RoleGroup roleGroup = (RoleGroup)this.roleGroupDAO.get(idRoleGroup);
        if (roleGroup == null) {
            throw new UserException("A role with that name not exists ! ");
        }
        List<User> listUserInRole = roleGroup.getListUser();
        List allUser = this.userDAO.getAll();
        if (allUser != null) {
            if (!listUserInRole.isEmpty()) {
                allUser.removeAll(listUserInRole);
            }
            for (User us : allUser) {
                listUserTO.add(this.rolesAndUsersTransfertObjectAssembler.toUserTO(us));
            }
        }
        return listUserTO;
    }

    @Override
    @CheckAllArgumentsNotNull
    public UserTO getUser(String userId) throws UserException {
        User user = (User)this.userDAO.get(userId);
        if (user == null) {
            throw new UserException("Can not find user in database ");
        }
        UserTO userTO = this.rolesAndUsersTransfertObjectAssembler.toUserTO(user);
        return userTO;
    }

    @Override
    public UserTO getUserByLogin(String login) throws UserException {
        User user = this.userDAO.getUserByName(login);
        if (user == null) {
            throw new UserException("Authentication failed : user '" + login + "' not found in database : ");
        }
        UserTO userTO = this.rolesAndUsersTransfertObjectAssembler.toUserTO(user);
        return userTO;
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeUser(String userId) throws UserException {
        User user = (User)this.userDAO.get(userId);
        if (user == null) {
            throw new UserException("Can not find and remove user in database ");
        }
        this.userDAO.remove(user);
    }

    @Override
    @CheckAllArgumentsNotNull
    public String updateUser(UserTO userTO) throws UserException {
        String id = userTO.getId();
        if (id == null) {
            throw new UserException("This user doesn't exist in database ");
        }
        User user = (User)this.userDAO.get(userTO.getId());
        if (user == null) {
            throw new UserException("This user doesn't exist in database ");
        }
        this.validateUserBeforSaveOrUpdate(userTO, user.getName());
        this.rolesAndUsersTransfertObjectAssembler.toUserBO(userTO, user);
        return this.userDAO.save(user).getId();
    }

    @Override
    @CheckAllArgumentsNotNull
    public void addRoleGroup(String idUser, String idRoleGroup) throws UserException {
        User user = (User)this.userDAO.get(idUser);
        if (user == null) {
            throw new UserException("You are trying to add a role to a non existing user with id: " + idUser);
        }
        RoleGroup roleGroup = (RoleGroup)this.roleGroupDAO.get(idRoleGroup);
        if (roleGroup == null) {
            throw new UserException("You are trying to add a non existing role to an user. Role id: " + idRoleGroup);
        }
        user.addRoleGroup(roleGroup);
        this.userDAO.save(user);
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeRoleGroup(String idUser, String idRoleGroup) throws UserException {
        User user = (User)this.userDAO.get(idUser);
        if (user == null) {
            throw new UserException("You are trying to remove a role to a non existing user with id: " + idUser);
        }
        RoleGroup roleGroup = (RoleGroup)this.roleGroupDAO.get(idRoleGroup);
        if (roleGroup == null) {
            throw new UserException("You are trying to remove a non existing role to an user. Role id: " + idRoleGroup);
        }
        user.removeRoleGroup(roleGroup);
        this.userDAO.save(user);
    }

    private void validateUserBeforSaveOrUpdate(UserTO userTO, String nameUser) throws UserException {
        User user;
        String nameUserTO = userTO.getName();
        if (StringHelper.isNullOrEmpty((String)nameUserTO) || StringHelper.isNullOrEmpty((String)userTO.getPassword())) {
            throw new UserException("User Name and its password must be speficied.");
        }
        if (!nameUserTO.equalsIgnoreCase(nameUser) && (user = this.userDAO.getUserByName(nameUserTO)) != null) {
            throw new UserException("A user with that name already exists : " + nameUserTO);
        }
    }

    public void setRolesAndUsersTransfertObjectAssembler(RolesAndUsersTransfertObjectAssembler rolesAndUsersTransfertObjectAssembler) {
        this.rolesAndUsersTransfertObjectAssembler = rolesAndUsersTransfertObjectAssembler;
    }

    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setRoleGroupDAO(RoleGroupDAO roleGroupDAO) {
        this.roleGroupDAO = roleGroupDAO;
    }
}

