/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.common;

import com.trg.search.Filter;
import com.trg.search.IMutableSearch;
import com.trg.search.Search;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.aop.annotation.CheckArgumentsNotNull;
import org.ow2.dragon.api.service.common.CommonException;
import org.ow2.dragon.api.service.common.EntityLinkManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.persistence.bo.common.Link;
import org.ow2.dragon.persistence.bo.common.LinkedEntity;
import org.ow2.dragon.persistence.dao.RequestOptions;
import org.ow2.dragon.persistence.dao.UniversalORMDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;

public class EntityLinkManagerImpl
implements EntityLinkManager {
    private Logger logger = Logger.getLogger(this.getClass());
    private UniversalORMDAO universalORMDAO;
    private TransfertObjectAssembler transfertObjectAssembler;

    @Override
    @CheckAllArgumentsNotNull
    public String createLink(String fromId, String toId, String type) throws CommonException {
        Link link = this.linkExist(fromId, toId, type);
        if (link != null) {
            this.logger.debug((Object)("Link already exist : " + link.toString() + ". Skip creation !"));
        } else {
            LinkedEntity from = this.retrieveLinkableEntity(fromId);
            LinkedEntity to = this.retrieveLinkableEntity(toId);
            link = new Link();
            link.setType(type);
            from.addFromLink(link);
            to.addToLink(link);
            this.universalORMDAO.save(link);
        }
        return link.getId();
    }

    private Link linkExist(String fromId, String toId, String type) {
        Search search = new Search();
        search.addFilter(Filter.equal((String)"from.id", (Object)fromId));
        search.addFilter(Filter.equal((String)"to.id", (Object)toId));
        search.addFilter(Filter.equal((String)"type", (Object)type));
        return (Link)this.universalORMDAO.searchUnique(Link.class, (IMutableSearch)search);
    }

    private LinkedEntity retrieveLinkableEntity(String linkableId) throws CommonException {
        LinkedEntity linkable = (LinkedEntity)this.universalORMDAO.get(LinkedEntity.class, (Serializable)((Object)linkableId));
        if (linkable == null) {
            throw new CommonException("One of the link end doesn't exist. Id: " + linkableId);
        }
        return linkable;
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeLink(String linkId) {
        this.universalORMDAO.remove(Link.class, (Serializable)((Object)linkId));
    }

    public void setTransfertObjectAssembler(TransfertObjectAssembler transfertObjectAssembler) {
        this.transfertObjectAssembler = transfertObjectAssembler;
    }

    public void setUniversalORMDAO(UniversalORMDAO universalORMDAO) {
        this.universalORMDAO = universalORMDAO;
    }

    @Override
    @CheckArgumentsNotNull
    public List<Link> getAllLinksForFrom(String fromId, RequestOptionsTO requestOptionsTO) {
        RequestOptions requestOptions = this.transfertObjectAssembler.toLinkRequestOptions(requestOptionsTO);
        if (requestOptions != null) {
            requestOptions.setCaseSensitive(true);
        }
        List links = this.universalORMDAO.searchEquals(Link.class, new String[]{fromId}, new String[]{"from.id"}, requestOptions);
        return links;
    }

    @Override
    @CheckArgumentsNotNull
    public List<Link> getAllLinksForTo(String toId, RequestOptionsTO requestOptionsTO) {
        RequestOptions requestOptions = this.transfertObjectAssembler.toLinkRequestOptions(requestOptionsTO);
        if (requestOptions != null) {
            requestOptions.setCaseSensitive(true);
        }
        List links = this.universalORMDAO.searchEquals(Link.class, new String[]{toId}, new String[]{"to.id"}, requestOptions);
        return links;
    }
}

