/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.dataloader;

import java.io.InputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.compass.gps.CompassGps;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.api.service.administration.RoleGroupException;
import org.ow2.dragon.api.service.administration.RoleGroupManager;
import org.ow2.dragon.api.service.administration.UserException;
import org.ow2.dragon.api.service.administration.UserManager;
import org.ow2.dragon.api.service.dataloader.DataLoader;
import org.ow2.dragon.api.service.dataloader.DataLoaderException;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.OrganizationManager;
import org.ow2.dragon.api.service.organization.PersonManager;
import org.ow2.dragon.api.service.organization.PostManager;
import org.ow2.dragon.api.service.wsdl.WSDLManager;
import org.ow2.dragon.api.to.administration.RoleGroupTO;
import org.ow2.dragon.api.to.administration.UserTO;
import org.ow2.dragon.api.to.organization.OrganizationUnitTO;
import org.ow2.dragon.api.to.organization.PersonTO;
import org.ow2.dragon.api.to.organization.PostTO;
import org.ow2.dragon.dataset.Dataset;
import org.ow2.dragon.dataset.Organization;
import org.ow2.dragon.dataset.Person;
import org.ow2.dragon.dataset.Post;
import org.ow2.dragon.dataset.PostToOrg;
import org.ow2.dragon.dataset.Role;
import org.ow2.dragon.dataset.User;
import org.ow2.dragon.dataset.UserToRole;
import org.ow2.dragon.dataset.Wsdl;
import org.ow2.dragon.service.dataloader.DragonDatasetHandler;
import org.ow2.dragon.util.InputStreamUtil;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

public class DataLoaderImpl
implements DataLoader {
    private final Logger logger = Logger.getLogger(this.getClass());
    private OrganizationManager organizationManager;
    private PostManager postManager;
    private PersonManager personManager;
    private WSDLManager wsdlManager;
    private UserManager userManager;
    private RoleGroupManager roleGroupManager;
    private CompassGps compassGps;
    private LocalSessionFactoryBean sessionFactory;

    @Override
    public void recreateDatabase() {
        this.sessionFactory.dropDatabaseSchema();
        this.sessionFactory.createDatabaseSchema();
    }

    @Override
    public void rebuildIndex() {
        this.compassGps.index();
    }

    @Override
    @CheckAllArgumentsNotNull
    public void loadDataSet(String xmlDataSetLocation) throws DataLoaderException {
        InputStream datasetStream;
        this.logger.info((Object)("Load a dragon dataset from location: " + xmlDataSetLocation));
        try {
            datasetStream = InputStreamUtil.getInputStream((String)xmlDataSetLocation);
        }
        catch (Exception e) {
            throw new DataLoaderException("Can't load Dragon dataset", e);
        }
        this.loadDataset(datasetStream);
    }

    @Override
    @CheckAllArgumentsNotNull
    public void loadDataset(InputStream datasetStream) throws DataLoaderException {
        Dataset dataset = null;
        try {
            dataset = DragonDatasetHandler.getInstance().convertStreamSource2DragonDataset(new StreamSource(datasetStream));
        }
        catch (Exception e) {
            throw new DataLoaderException("Can't load Dragon dataset", e);
        }
        HashMap<String, String> orgIndexToOrgId = new HashMap<String, String>();
        this.loadOrganizationUnits(dataset, orgIndexToOrgId);
        HashMap<String, String> postIndexToPostId = new HashMap<String, String>();
        this.loadPosts(dataset, postIndexToPostId);
        this.addPostToOrg(dataset, orgIndexToOrgId, postIndexToPostId);
        HashMap<String, String> personIndexToPersonId = new HashMap<String, String>();
        this.loadPersons(dataset, personIndexToPersonId, postIndexToPostId, orgIndexToOrgId);
        this.importWSDLs(dataset);
        HashMap<String, String> roleIndexToRoleId = new HashMap<String, String>();
        this.loadRoles(dataset, roleIndexToRoleId);
        HashMap<String, String> userIndexToUserId = new HashMap<String, String>();
        this.loadUsers(dataset, userIndexToUserId, personIndexToPersonId);
        this.addRoleToUser(dataset, userIndexToUserId, roleIndexToRoleId);
    }

    private void importWSDLs(Dataset dataset) throws DataLoaderException {
        List<Wsdl> wsdls = dataset.getWsdl();
        for (Wsdl wsdl : wsdls) {
            try {
                this.wsdlManager.importServiceDefFile(URI.create(wsdl.getUrl()));
            }
            catch (Exception e) {
                throw new DataLoaderException("Can't import wsdl from URL: " + wsdl.getUrl(), e);
            }
        }
    }

    private void loadPersons(Dataset dataset, Map<String, String> personIndexToPersonId, Map<String, String> postIndexToPostId, Map<String, String> orgIndexToOrgId) throws DataLoaderException {
        this.logger.debug((Object)"Load persons from dataset");
        List<Person> persons = dataset.getPerson();
        for (Person person : persons) {
            String orgIndex;
            PersonTO personTO = new PersonTO();
            personTO.setEmail(person.getEmailAddress());
            personTO.setFirstname(person.getFirstName());
            personTO.setLastname(person.getLastName());
            personTO.setLocalization(person.getLocalization());
            personTO.setMiddlename(person.getMiddleName());
            if (person.isContact() != null) {
                personTO.setContact(person.isContact());
            }
            if ((orgIndex = person.getOrgIndex()) != null) {
                OrganizationUnitTO org = null;
                try {
                    org = this.organizationManager.getOrganization(orgIndexToOrgId.get(orgIndex));
                }
                catch (OrganizationException e) {
                    throw new DataLoaderException("Can't load mother org for index: " + orgIndex, e);
                }
                personTO.setOrganization(org);
            }
            personTO.setPhone(person.getPhoneNumber());
            String postIndex = person.getPostIndex();
            if (postIndex != null) {
                PostTO post = null;
                try {
                    post = this.postManager.getPost(postIndexToPostId.get(postIndex));
                }
                catch (OrganizationException e) {
                    throw new DataLoaderException("Can't load post for index: " + postIndex, e);
                }
                personTO.setPost(post);
            }
            personTO.setTitle(person.getTitle());
            try {
                String personId = this.personManager.createPerson(personTO);
                personIndexToPersonId.put(person.getIndex(), personId);
            }
            catch (OrganizationException e) {
                throw new DataLoaderException("Can't create person with index: " + person.getIndex(), e);
            }
        }
    }

    private void addRoleToUser(Dataset dataset, Map<String, String> userIndexToUserId, Map<String, String> roleIndexToRoleId) throws DataLoaderException {
        this.logger.debug((Object)"Add role to users");
        List<UserToRole> userToRoles = dataset.getUserToRole();
        for (UserToRole userToRole : userToRoles) {
            try {
                this.roleGroupManager.addUser(userIndexToUserId.get(userToRole.getUserIndex()), roleIndexToRoleId.get(userToRole.getRoleIndex()));
            }
            catch (RoleGroupException e) {
                throw new DataLoaderException("Can't add user with index '" + userToRole.getUserIndex() + "' to role with index '" + userToRole.getRoleIndex() + "'", e);
            }
        }
    }

    private void addPostToOrg(Dataset dataset, Map<String, String> orgIndexToOrgId, Map<String, String> postIndexToPostId) throws DataLoaderException {
        this.logger.debug((Object)"Add post to orgs");
        List<PostToOrg> postToOrgs = dataset.getPostToOrg();
        for (PostToOrg postToOrg : postToOrgs) {
            try {
                this.organizationManager.addPost(orgIndexToOrgId.get(postToOrg.getOrgIndex()), postIndexToPostId.get(postToOrg.getPostIndex()));
            }
            catch (OrganizationException e) {
                throw new DataLoaderException("Can't add post with index '" + postToOrg.getPostIndex() + "' to org with index '" + postToOrg.getOrgIndex() + "'", e);
            }
        }
    }

    private void loadPosts(Dataset dataset, Map<String, String> postIndexToPostId) throws DataLoaderException {
        this.logger.debug((Object)"Load posts from dataset");
        List<Post> posts = dataset.getPost();
        for (Post post : posts) {
            PostTO postTO = new PostTO();
            postTO.setDescription(post.getDescription());
            postTO.setName(post.getName());
            postTO.setNature(post.getNature());
            if (post.isContact() != null) {
                postTO.setContact(post.isContact());
            }
            try {
                String postId = this.postManager.createPost(postTO);
                postIndexToPostId.put(post.getIndex(), postId);
            }
            catch (OrganizationException e) {
                throw new DataLoaderException("Can't create post with index: " + post.getIndex(), e);
            }
        }
    }

    private void loadRoles(Dataset dataset, Map<String, String> roleIndexToRoleId) throws DataLoaderException {
        this.logger.debug((Object)"Load roles from dataset");
        List<Role> roles = dataset.getRole();
        for (Role role : roles) {
            RoleGroupTO roleGroupTO = new RoleGroupTO();
            roleGroupTO.setName(role.getName());
            roleGroupTO.setListRoles(role.getRight());
            try {
                String roleId = this.roleGroupManager.createRoleGroup(roleGroupTO);
                roleIndexToRoleId.put(role.getIndex(), roleId);
            }
            catch (RoleGroupException e) {
                throw new DataLoaderException("Can't create role with index: " + role.getIndex(), e);
            }
        }
    }

    private void loadUsers(Dataset dataset, Map<String, String> userIndexToUserId, Map<String, String> personIndexToPersonId) throws DataLoaderException {
        this.logger.debug((Object)"Load users from dataset");
        List<User> users = dataset.getUser();
        for (User user : users) {
            UserTO userTO = new UserTO();
            userTO.setName(user.getName());
            userTO.setPassword(this.passwordCrypting(user.getPassword()));
            String personIndex = user.getPersonIndex();
            if (personIndex != null) {
                PersonTO person = null;
                try {
                    person = this.personManager.getPerson(personIndexToPersonId.get(personIndex));
                }
                catch (OrganizationException e) {
                    throw new DataLoaderException("Can't load person for index: " + personIndex, e);
                }
                userTO.setPerson(person);
            }
            try {
                String userId = this.userManager.createUser(userTO);
                userIndexToUserId.put(user.getIndex(), userId);
            }
            catch (UserException e) {
                throw new DataLoaderException("Can't create user with index: " + user.getIndex(), e);
            }
        }
    }

    private String passwordCrypting(String password) {
        byte[] uniqueKey = password.getBytes();
        byte[] hash = null;
        try {
            hash = MessageDigest.getInstance("MD5").digest(uniqueKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("No MD5 support in this VM.");
        }
        StringBuilder hashString = new StringBuilder();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(hash[i]);
            if (hex.length() == 1) {
                hashString.append('0');
                hashString.append(hex.charAt(hex.length() - 1));
                continue;
            }
            hashString.append(hex.substring(hex.length() - 2));
        }
        return hashString.toString();
    }

    private void loadOrganizationUnits(Dataset dataset, Map<String, String> orgIndexToOrgId) throws DataLoaderException {
        this.logger.debug((Object)"Load organizations from dataset");
        List<Organization> orgs = dataset.getOrganisation();
        for (Organization organization : orgs) {
            OrganizationUnitTO organizationUnitTO = new OrganizationUnitTO();
            organizationUnitTO.setCity(organization.getCity());
            organizationUnitTO.setComplement(organization.getComplement());
            organizationUnitTO.setCountry(organization.getCountry());
            organizationUnitTO.setDiscoveryURL(organization.getDiscoveryURL());
            organizationUnitTO.setEmailAddress(organization.getEmailAddress());
            organizationUnitTO.setIsLegalEntity(organization.isIsLegalEntity());
            String motherOrgIndex = organization.getMotherOrganizationIndex();
            if (motherOrgIndex != null) {
                OrganizationUnitTO motherOrg = null;
                try {
                    motherOrg = this.organizationManager.getOrganization(orgIndexToOrgId.get(motherOrgIndex));
                }
                catch (OrganizationException e) {
                    throw new DataLoaderException("Can't load mother org for index: " + motherOrgIndex, e);
                }
                organizationUnitTO.setMotherOrganization(motherOrg);
            }
            organizationUnitTO.setName(organization.getName());
            organizationUnitTO.setState(organization.getState());
            organizationUnitTO.setStreet(organization.getStreet());
            organizationUnitTO.setStreetNumber(organization.getStreetNumber());
            organizationUnitTO.setType(organization.getType());
            organizationUnitTO.setZipcode(organization.getZipcode());
            try {
                String orgId = this.organizationManager.createOrganization(organizationUnitTO);
                orgIndexToOrgId.put(organization.getIndex(), orgId);
            }
            catch (OrganizationException e) {
                throw new DataLoaderException("Can't create organization with index: " + organization.getIndex(), e);
            }
        }
    }

    public void setOrganizationManager(OrganizationManager organizationManager) {
        this.organizationManager = organizationManager;
    }

    public void setPostManager(PostManager postManager) {
        this.postManager = postManager;
    }

    public void setPersonManager(PersonManager personManager) {
        this.personManager = personManager;
    }

    public void setWsdlManager(WSDLManager wsdlManager) {
        this.wsdlManager = wsdlManager;
    }

    public void setCompassGps(CompassGps compassGps) {
        this.compassGps = compassGps;
    }

    public void setSessionFactory(LocalSessionFactoryBean sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setRoleGroupManager(RoleGroupManager roleGroupManager) {
        this.roleGroupManager = roleGroupManager;
    }
}

