/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.metadata;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.sax.BodyContentHandler;
import org.ow2.dragon.api.service.metadata.MetadataService;
import org.ow2.dragon.api.service.metadata.MetadataServiceException;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.persistence.dao.metadata.SimpleFileDAO;
import org.ow2.dragon.service.metadata.RepositoryType;
import org.ow2.dragon.util.ContentType;
import org.ow2.dragon.util.InputStreamUtil;
import org.ow2.dragon.util.StringHelper;
import org.ow2.dragon.util.UDDIUseType;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MetadataServiceImpl
implements MetadataService {
    private static final String regSymbol19 = "\\s+";
    private static final String regSymbol20 = "^\\s";
    private static final String regSymbol21 = "\\s+$//";
    private static final String space = " ";
    private static final String noSpace = "";
    private SimpleFileDAO simpleFileDAO;
    private File repositoryRootFile;
    private RepositoryType repoType;
    private Logger logger = Logger.getLogger(this.getClass());

    public MetadataServiceImpl(String repositoryRoot, SimpleFileDAO simpleFileDAO, String repoType) throws IOException, MetadataServiceException {
        this.simpleFileDAO = simpleFileDAO;
        this.repoType = RepositoryType.fromString(repoType);
        if (this.repoType == null) {
            throw new MetadataServiceException("Repository type not supported: \"" + repoType + "\". Supported types are: \"" + RepositoryType.DATABASE.toString() + "\" and \"" + RepositoryType.FILE_SYSTEM.toString() + "\"");
        }
        switch (this.repoType) {
            case DATABASE: {
                break;
            }
            case FILE_SYSTEM: {
                this.initRepository(repositoryRoot);
                break;
            }
        }
    }

    private void initRepository(String repositoryRoot) throws IOException {
        this.repositoryRootFile = new File(repositoryRoot);
        FileUtils.forceMkdir((File)this.repositoryRootFile);
    }

    @Override
    public void cleanupRepository() {
        switch (this.repoType) {
            case DATABASE: {
                this.logger.info((Object)"A database repository cannot be cleanup");
                break;
            }
            case FILE_SYSTEM: {
                List<File> allFileList = Arrays.asList(this.repositoryRootFile.listFiles());
                for (File file : allFileList) {
                    if (this.isMappedInDB(file)) continue;
                    FileUtils.deleteQuietly((File)file);
                }
                break;
            }
        }
    }

    private boolean isMappedInDB(File file) {
        boolean bool = false;
        List result = this.simpleFileDAO.searchEquals(new String[]{file.getName()}, new String[]{"location"}, null);
        if (result != null && !result.isEmpty()) {
            bool = true;
        }
        return bool;
    }

    @Override
    public void deleteMetadata(String metadataId) {
        File file;
        String location;
        SimpleFile simpleFile = (SimpleFile)this.simpleFileDAO.get(metadataId);
        if (this.repoType == RepositoryType.FILE_SYSTEM && !StringHelper.isNullOrEmpty((String)(location = simpleFile.getLocation())) && (file = new File(location)).exists()) {
            FileUtils.deleteQuietly((File)file);
        }
        this.simpleFileDAO.remove(metadataId);
    }

    public SimpleFileDAO getSimpleFileDAO() {
        return this.simpleFileDAO;
    }

    public byte[] loadMetadataContent(String id) {
        throw new RuntimeException("not implemented method");
    }

    @Override
    public byte[] loadMetadataContentAsBytes(String id) {
        throw new RuntimeException("not implemented method");
    }

    @Override
    public InputStream loadMetadataContentAsInputStream(String id) throws MetadataServiceException {
        SimpleFile simpleFile = (SimpleFile)this.simpleFileDAO.get(id);
        if (simpleFile == null) {
            throw new MetadataServiceException("Can't load file for id: " + id);
        }
        InputStream inputStream = null;
        switch (this.repoType) {
            case DATABASE: {
                byte[] blob = simpleFile.getContent();
                inputStream = new ByteArrayInputStream(blob);
                break;
            }
            case FILE_SYSTEM: {
                inputStream = this.retrieveContentFromFileSystem(simpleFile.getLocation());
                break;
            }
        }
        return inputStream;
    }

    private InputStream retrieveContentFromFileSystem(String location) throws MetadataServiceException {
        File data = new File(this.repositoryRootFile, location);
        FileInputStream inputStream = null;
        try {
            inputStream = FileUtils.openInputStream((File)data);
        }
        catch (IOException e) {
            throw new MetadataServiceException("Can't load file from file system", e);
        }
        return inputStream;
    }

    @Override
    public SimpleFile storeMetadataAndIndexContent(ContentType type, byte[] content, String fileName) throws MetadataServiceException {
        SimpleFile simpleFile = this.createSimpleFile(type, content, fileName, null);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content);
        try {
            this.extractInformation(byteArrayInputStream, simpleFile, true);
        }
        catch (Exception e) {
            throw new MetadataServiceException("Can't extract information from the given content", e);
        }
        this.simpleFileDAO.save(simpleFile);
        return simpleFile;
    }

    @Override
    public SimpleFile storeMetadataAndIndexContent(byte[] content, String fileName) throws MetadataServiceException {
        SimpleFile simpleFile = this.createSimpleFile(null, content, fileName, null);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content);
        try {
            this.extractInformation(byteArrayInputStream, simpleFile, true);
        }
        catch (Exception e) {
            throw new MetadataServiceException("Can't extract information from the given content", e);
        }
        this.simpleFileDAO.save(simpleFile);
        return simpleFile;
    }

    private String storeDataInFileSystem(String id, byte[] content, ContentType type) throws MetadataServiceException {
        String suffix = ContentType.getRelatedSuffix((ContentType)type);
        String location = id + suffix;
        File data = new File(this.repositoryRootFile, location);
        try {
            FileUtils.writeByteArrayToFile((File)data, (byte[])content);
        }
        catch (IOException e) {
            throw new MetadataServiceException("Can't write file to filesystem", e);
        }
        return data.getName();
    }

    private SimpleFile createSimpleFile(ContentType type, byte[] content, String fileName, UDDIUseType useType) throws MetadataServiceException {
        SimpleFile simpleFile = new SimpleFile();
        simpleFile.setFileType(type);
        simpleFile.setFileName(fileName);
        simpleFile.setUseType(useType);
        simpleFile = this.simpleFileDAO.save(simpleFile);
        switch (this.repoType) {
            case DATABASE: {
                simpleFile.setContent(content);
                break;
            }
            case FILE_SYSTEM: {
                String location = this.storeDataInFileSystem(simpleFile.getId(), content, type);
                simpleFile.setLocation(location);
                break;
            }
        }
        this.simpleFileDAO.save(simpleFile);
        return simpleFile;
    }

    private String removeSuffix(String fileName, ContentType type) {
        String suffix;
        if (fileName != null && fileName.endsWith(suffix = ContentType.getRelatedSuffix((ContentType)type))) {
            fileName = fileName.substring(0, fileName.length() - suffix.length() - 1);
        }
        return fileName;
    }

    private void extractInformation(ByteArrayInputStream byteArrayInputStream, SimpleFile simpleFile, boolean indexContent) throws IOException, SAXException, TikaException, MetadataServiceException {
        AutoDetectParser parser = new AutoDetectParser();
        StringWriter writer = new StringWriter();
        BodyContentHandler handler = new BodyContentHandler((Writer)writer);
        Metadata metadata = new Metadata();
        parser.parse((InputStream)byteArrayInputStream, (ContentHandler)handler, metadata);
        simpleFile.setAuthor(metadata.get("Author"));
        simpleFile.setTitle(metadata.get("title"));
        if (simpleFile.getFileType() == null) {
            String extractedContentType = metadata.get("Content-Type");
            ContentType contentType = ContentType.fromString((String)extractedContentType);
            if (contentType == null) {
                throw new MetadataServiceException("Can't register document. Content type not supported : " + extractedContentType);
            }
            simpleFile.setFileType(contentType);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"#### Extracted Metadata : ");
            this.logger.debug((Object)("Author: " + simpleFile.getAuthor()));
            this.logger.debug((Object)("Title: " + simpleFile.getTitle()));
            this.logger.debug((Object)("Content Type: " + simpleFile.getFileType()));
        }
        if (indexContent) {
            String cleanupContent = this.cleanupContent(writer);
            simpleFile.setExtractedContent(cleanupContent);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"#### Extracted Content : ");
                this.logger.debug((Object)cleanupContent);
            }
        }
    }

    private String cleanupContent(StringWriter writer) {
        String content = writer.toString();
        content = content.replaceAll(regSymbol19, space);
        content = content.replaceAll(regSymbol20, noSpace);
        content = content.replaceAll(regSymbol21, noSpace);
        return content;
    }

    @Override
    public SimpleFile storeMetadata(ContentType type, URI contentURI, String fileName) throws MetadataServiceException {
        return this.storeMetadata(type, contentURI, fileName, null);
    }

    @Override
    public SimpleFile storeMetadata(ContentType type, URI contentURI, String fileName, UDDIUseType useType) throws MetadataServiceException {
        try {
            return this.storeMetadata(type, InputStreamUtil.getBytes((InputStream)InputStreamUtil.getInputStream((URI)contentURI)), fileName, useType);
        }
        catch (IOException e) {
            throw new MetadataServiceException("Can't read data at the given URL:" + contentURI, e);
        }
        catch (URISyntaxException e) {
            throw new MetadataServiceException("Given data URI is invalid:" + contentURI, e);
        }
    }

    @Override
    public SimpleFile storeMetadata(ContentType type, String fileContent, String fileName) throws MetadataServiceException {
        return this.storeMetadata(type, fileContent, fileName, null);
    }

    @Override
    public SimpleFile storeMetadata(ContentType type, String fileContent, String fileName, UDDIUseType useType) throws MetadataServiceException {
        byte[] fileContentAsByte = fileContent.getBytes();
        SimpleFile simpleFile = this.createSimpleFile(type, fileContentAsByte, fileName, useType);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileContentAsByte);
        try {
            this.extractInformation(byteArrayInputStream, simpleFile, false);
        }
        catch (Exception e) {
            throw new MetadataServiceException("Can't extract information from the given content", e);
        }
        this.simpleFileDAO.save(simpleFile);
        return simpleFile;
    }

    @Override
    public SimpleFile loadMetadata(String id) {
        return (SimpleFile)this.simpleFileDAO.get(id);
    }

    @Override
    public SimpleFile storeMetadataAndIndexContent(String mimetype, byte[] docContent, String fileName) throws MetadataServiceException {
        SimpleFile result = null;
        ContentType contentType = ContentType.fromString((String)mimetype);
        if (contentType == null) {
            throw new MetadataServiceException("Can't register document. Content type not supported : " + mimetype);
        }
        result = this.storeMetadataAndIndexContent(contentType, docContent, fileName);
        return result;
    }

    @Override
    public SimpleFile storeMetadata(ContentType type, byte[] content) throws MetadataServiceException {
        SimpleFile simpleFile = this.createSimpleFile(type, content, null, null);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content);
        try {
            this.extractInformation(byteArrayInputStream, simpleFile, false);
        }
        catch (Exception e) {
            throw new MetadataServiceException("Can't extract information from the given content", e);
        }
        this.simpleFileDAO.save(simpleFile);
        return simpleFile;
    }

    @Override
    public SimpleFile storeMetadata(ContentType type, String fileContent) throws MetadataServiceException {
        return this.storeMetadata(type, fileContent, null);
    }

    @Override
    public SimpleFile storeMetadata(ContentType type, URI contentURI) throws MetadataServiceException {
        return this.storeMetadata(type, contentURI, null);
    }

    @Override
    public SimpleFile storeMetadataAndIndexContent(byte[] content) throws MetadataServiceException {
        return this.storeMetadataAndIndexContent(content, null);
    }

    @Override
    public SimpleFile storeMetadataAndIndexContent(ContentType type, byte[] content) throws MetadataServiceException {
        return this.storeMetadataAndIndexContent(type, content, null);
    }

    @Override
    public SimpleFile storeMetadataAndIndexContent(String mimetype, byte[] docContent) throws MetadataServiceException {
        return this.storeMetadataAndIndexContent(mimetype, docContent, null);
    }

    @Override
    public SimpleFile storeMetadata(ContentType type, byte[] content, String fileName) throws MetadataServiceException {
        return this.storeMetadata(type, content, fileName, null);
    }

    public SimpleFile storeMetadata(ContentType type, byte[] content, String fileName, UDDIUseType useType) throws MetadataServiceException {
        SimpleFile simpleFile = this.createSimpleFile(type, content, fileName, useType);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content);
        try {
            this.extractInformation(byteArrayInputStream, simpleFile, false);
        }
        catch (Exception e) {
            throw new MetadataServiceException("Can't extract information from the given content", e);
        }
        this.simpleFileDAO.save(simpleFile);
        return simpleFile;
    }

    @Override
    public String getRepositoryRootPath() {
        String rootPath = null;
        if (this.repositoryRootFile != null) {
            rootPath = this.repositoryRootFile.getAbsolutePath();
        }
        return rootPath;
    }
}

