/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.sla;

import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.EndpointReferenceType;
import com.ebmwebsourcing.agreement.definition.WSAgreementFactory;
import com.ebmwebsourcing.agreement.definition.api.Agreement;
import com.ebmwebsourcing.agreement.definition.api.AgreementLifeCycle;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.dm.api.WSDMException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.service.deployment.TechServiceManager;
import org.ow2.dragon.api.service.metadata.MetadataService;
import org.ow2.dragon.api.service.metadata.MetadataServiceException;
import org.ow2.dragon.api.service.organization.RoleOfPartyManager;
import org.ow2.dragon.api.service.sla.SLAManager;
import org.ow2.dragon.api.service.sla.SLAServiceException;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.organization.PersonToEndpointTO;
import org.ow2.dragon.api.to.sla.ManagedAgreementTO;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.persistence.bo.organization.Party;
import org.ow2.dragon.persistence.bo.sla.ManagedAgreement;
import org.ow2.dragon.persistence.dao.deployment.EndpointDAO;
import org.ow2.dragon.persistence.dao.organization.PartyDAO;
import org.ow2.dragon.persistence.dao.sla.ManagedAgreementDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;
import org.ow2.dragon.service.sla.SLATransfertObjectAssembler;
import org.ow2.dragon.util.ContentType;
import org.ow2.dragon.util.InputStreamUtil;
import org.ow2.dragon.util.SearchHelper;
import org.ow2.dragon.util.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SLAManagerImpl
implements SLAManager {
    private MetadataService metadataService;
    private ManagedAgreementDAO managedAgreementDAO;
    private SLATransfertObjectAssembler slatransfertObjectAssembler;
    private TransfertObjectAssembler transfertObjectAssembler;
    private TechServiceManager techServiceManager;
    private RoleOfPartyManager roleOfPartyManager;
    private PartyDAO partyDAO;
    private EndpointDAO endpointDAO;

    @Override
    public String createManagedAgreement(ManagedAgreementTO managedAgreementTO) throws SLAServiceException {
        String res = null;
        try {
            ManagedAgreement a = this.slatransfertObjectAssembler.toManagedAgreementBO(managedAgreementTO);
            String buffer = WSAgreementFactory.newInstance().newWSAgreementWriter().write(managedAgreementTO.getAgreement());
            SimpleFile agreementFile = this.metadataService.storeMetadata(ContentType.XML, buffer.getBytes());
            a.setAgreementFile(agreementFile);
            res = this.managedAgreementDAO.save(a).getId();
        }
        catch (WSAgreementException e) {
            throw new SLAServiceException(e);
        }
        catch (MetadataServiceException e) {
            throw new SLAServiceException(e);
        }
        return res;
    }

    private String[] createSearchProperties(List<String> searchedProperties) {
        ArrayList<String> propertiesList = new ArrayList<String>();
        if (searchedProperties != null && !searchedProperties.isEmpty()) {
            if (searchedProperties.contains("name")) {
                propertiesList.add("name");
            }
            if (searchedProperties.contains("initiator")) {
                propertiesList.add("initiator");
            }
            if (searchedProperties.contains("responder")) {
                propertiesList.add("responder");
            }
        } else {
            propertiesList.add("name");
            propertiesList.add("initiator");
            propertiesList.add("responder");
        }
        return propertiesList.toArray(new String[0]);
    }

    @Override
    public List<ManagedAgreementTO> getAllManagedAgreements(RequestOptionsTO requestOptionsTO) throws SLAServiceException {
        ArrayList<ManagedAgreementTO> result = new ArrayList<ManagedAgreementTO>();
        List agreements = this.managedAgreementDAO.getAll(this.transfertObjectAssembler.toAgreementRequestOptions(requestOptionsTO));
        try {
            if (agreements != null && !agreements.isEmpty()) {
                for (ManagedAgreement agreement : agreements) {
                    ManagedAgreementTO maTO = this.slatransfertObjectAssembler.toManagedAgreementTO(agreement);
                    InputStream inputStream = this.metadataService.loadMetadataContentAsInputStream(agreement.getAgreementFile().getId());
                    Agreement a = WSAgreementFactory.newInstance().newWSAgreementReader().read(new InputSource(inputStream));
                    maTO.setAgreement(a);
                    if (a instanceof AgreementLifeCycle) {
                        ((AgreementLifeCycle)a).setState(AgreementLifeCycle.State.fromValue((String)maTO.getState()));
                    }
                    result.add(maTO);
                }
            }
        }
        catch (WSAgreementException e) {
            throw new SLAServiceException("Cannot convert agreement to agreement TO: " + e.getMessage(), e);
        }
        catch (MetadataServiceException e) {
            throw new SLAServiceException("Cannot convert agreement to agreement TO: " + e.getMessage(), e);
        }
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public ManagedAgreementTO getManagedAgreement(String id) throws SLAServiceException {
        ManagedAgreementTO agreementTO = null;
        ManagedAgreement ag = (ManagedAgreement)this.managedAgreementDAO.get(id);
        if (ag == null) {
            throw new SLAServiceException("Impossible to find agreement with id: " + id);
        }
        try {
            agreementTO = this.slatransfertObjectAssembler.toManagedAgreementTO(ag);
            if (agreementTO.getAgreement() instanceof AgreementLifeCycle) {
                ((AgreementLifeCycle)agreementTO.getAgreement()).setState(AgreementLifeCycle.State.fromValue((String)agreementTO.getState()));
            }
        }
        catch (WSAgreementException e) {
            throw new SLAServiceException("Can't parse sla agreement: " + e.getMessage(), e);
        }
        return agreementTO;
    }

    public ManagedAgreementDAO getManagedAgreementDAO() {
        return this.managedAgreementDAO;
    }

    public SLATransfertObjectAssembler getSlatransfertObjectAssembler() {
        return this.slatransfertObjectAssembler;
    }

    public TechServiceManager getTechServiceManager() {
        return this.techServiceManager;
    }

    public TransfertObjectAssembler getTransfertObjectAssembler() {
        return this.transfertObjectAssembler;
    }

    @Override
    public String importAgreementDefFile(Document slaContent) throws SLAServiceException {
        String storedSLAId = null;
        try {
            InputSource agreementSource;
            ManagedAgreement managedAgreement = null;
            Agreement agreement = WSAgreementFactory.newInstance().newWSAgreementReader().read(slaContent);
            managedAgreement = this.isEditable(agreement) ? new ManagedAgreement(true) : new ManagedAgreement(false);
            if (agreement.getContext() != null && agreement.getContext().getResponder() != null) {
                String endpointRef = agreement.getContext().getResponder().getAddress();
                String[] addr = endpointRef.split("::");
                if (addr == null || addr.length != 2) {
                    throw new WSDMException("Endpoint address is not correctly formatted => {ns}ServiceName::EndpointName and not: " + endpointRef);
                }
                QName serviceName = QName.valueOf(addr[0].trim());
                String endpointName = addr[1].trim();
                EndpointTO endpoint = this.techServiceManager.getEndpoint(serviceName.toString(), endpointName);
                if (endpoint == null) {
                    throw new WSDMException("Impossible to find the endpoint responder corresponding to " + endpointRef);
                }
                List<PersonToEndpointTO> persons = this.roleOfPartyManager.getPersonRolesByEndpoint(endpoint.getId(), null);
                ArrayList<PersonToEndpointTO> managers = new ArrayList<PersonToEndpointTO>();
                for (PersonToEndpointTO person : persons) {
                    if (!person.getType().equals("Manager")) continue;
                    managers.add(person);
                }
                if (managers.size() > 1) {
                    throw new WSDMException("Impossible to affect agreement because there are several managers for this endpoint: " + endpointRef);
                }
                if (managers.size() == 1) {
                    Party party = (Party)this.partyDAO.get(((PersonToEndpointTO)managers.get(0)).getPartyTO().getId());
                    if (party == null) {
                        throw new WSDMException("Impossible to find the party corresponding to this id:  " + ((PersonToEndpointTO)managers.get(0)).getPartyTO().getId());
                    }
                    managedAgreement.setProvider(party);
                }
                managedAgreement.setInitiator(agreement.getContext().getInitiator().getAddress());
                managedAgreement.setResponder(agreement.getContext().getResponder().getAddress());
                Endpoint ep = (Endpoint)this.endpointDAO.get(endpoint.getId());
                if (ep == null) {
                    throw new WSDMException("Impossible to find the endpoint corresponding to this id:  " + endpoint.getId());
                }
                managedAgreement.setEndpoint(ep);
            }
            try {
                agreementSource = XMLUtil.createWsdlSource((Document)slaContent);
            }
            catch (Exception e1) {
                throw new SLAServiceException("Can't read wsdl file", e1);
            }
            SimpleFile agreementFile = this.metadataService.storeMetadata(ContentType.XML, InputStreamUtil.getBytes((InputStream)agreementSource.getByteStream()), slaContent.getDocumentURI());
            managedAgreement.setAgreementFile(agreementFile);
            storedSLAId = this.managedAgreementDAO.save(managedAgreement).getId();
        }
        catch (MetadataServiceException e) {
            throw new SLAServiceException("Can't register sla file to persistent storage: " + e.getMessage(), e);
        }
        catch (WSAgreementException e) {
            throw new SLAServiceException("Can't create sla agreement: " + e.getMessage(), e);
        }
        catch (WSAddressingException e) {
            throw new SLAServiceException("Can't create sla agreement: " + e.getMessage(), e);
        }
        catch (WSDMException e) {
            throw new SLAServiceException("Can't create sla agreement: " + e.getMessage(), e);
        }
        catch (DeploymentException e) {
            throw new SLAServiceException("Can't create sla agreement: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SLAServiceException("Can't create sla agreement: " + e.getMessage(), e);
        }
        return storedSLAId;
    }

    public void setPartyDAO(PartyDAO partyDAO) {
        this.partyDAO = partyDAO;
    }

    @Override
    public String importAgreementDefFile(URI slaURI) throws SLAServiceException {
        Object storedSLAId = null;
        Document slaContent = null;
        try {
            slaContent = XMLUtil.createDocument((InputStream)InputStreamUtil.getInputStream((URI)slaURI));
            slaContent.setDocumentURI(slaURI.toString());
        }
        catch (SAXException e) {
            throw new SLAServiceException("Can't create sla agreement: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SLAServiceException("Can't create sla agreement: " + e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            throw new SLAServiceException("Can't create sla agreement: " + e.getMessage(), e);
        }
        return this.importAgreementDefFile(slaContent);
    }

    private boolean isEditable(Agreement ag) throws SLAServiceException {
        boolean res = true;
        try {
            if (ag.getContext() != null) {
                if (!(ag.getContext().getInitiator() instanceof EndpointReferenceType)) {
                    res = false;
                }
                if (!(ag.getContext().getResponder() instanceof EndpointReferenceType)) {
                    res = false;
                }
            }
        }
        catch (WSAddressingException e) {
            throw new SLAServiceException(e);
        }
        if (res) {
            // empty if block
        }
        return res;
    }

    @Override
    public void removeManagedAgreement(String id) throws SLAServiceException {
        this.managedAgreementDAO.remove(id);
    }

    @Override
    public List<ManagedAgreementTO> searchManagedAgreement(String searchCriteria, List<String> searchedProperties, RequestOptionsTO options) throws SLAServiceException {
        ArrayList<ManagedAgreementTO> result = new ArrayList<ManagedAgreementTO>();
        String[] criteria = SearchHelper.splitSearchCriteria((String)searchCriteria);
        String[] properties = this.createSearchProperties(searchedProperties);
        List agreementsBO = this.managedAgreementDAO.searchEquals(criteria, properties, this.transfertObjectAssembler.toAgreementRequestOptions(options));
        try {
            if (agreementsBO != null && !agreementsBO.isEmpty()) {
                for (ManagedAgreement managedAgreement : agreementsBO) {
                    ManagedAgreementTO mabTO = this.slatransfertObjectAssembler.toManagedAgreementTO(managedAgreement);
                    InputStream inputStream = this.metadataService.loadMetadataContentAsInputStream(managedAgreement.getAgreementFile().getId());
                    Agreement a = WSAgreementFactory.newInstance().newWSAgreementReader().read(new InputSource(inputStream));
                    mabTO.setAgreement(a);
                    if (a instanceof AgreementLifeCycle) {
                        ((AgreementLifeCycle)a).setState(AgreementLifeCycle.State.fromValue((String)mabTO.getState()));
                    }
                    result.add(mabTO);
                }
            }
        }
        catch (WSAgreementException e) {
            throw new SLAServiceException(e);
        }
        catch (MetadataServiceException e) {
            throw new SLAServiceException(e);
        }
        return result;
    }

    public void setManagedAgreementDAO(ManagedAgreementDAO managedAgreementDAO) {
        this.managedAgreementDAO = managedAgreementDAO;
    }

    public void setMetadataService(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    public void setSlatransfertObjectAssembler(SLATransfertObjectAssembler slatransfertObjectAssembler) {
        this.slatransfertObjectAssembler = slatransfertObjectAssembler;
    }

    public void setTechServiceManager(TechServiceManager techServiceManager) {
        this.techServiceManager = techServiceManager;
    }

    public void setTransfertObjectAssembler(TransfertObjectAssembler transfertObjectAssembler) {
        this.transfertObjectAssembler = transfertObjectAssembler;
    }

    public void setRoleOfPartyManager(RoleOfPartyManager roleOfPartyManager) {
        this.roleOfPartyManager = roleOfPartyManager;
    }

    public void setEndpointDAO(EndpointDAO endpointDAO) {
        this.endpointDAO = endpointDAO;
    }

    @Override
    public String updateManagedAgreement(ManagedAgreementTO managedAgreementTO) throws SLAServiceException {
        ManagedAgreement managedAgreement = (ManagedAgreement)this.managedAgreementDAO.get(managedAgreementTO.getId());
        if (managedAgreement == null) {
            throw new SLAServiceException("Your are trying to update a non existing agreement with id: " + managedAgreementTO.getId());
        }
        try {
            this.slatransfertObjectAssembler.toManagedAgreementBO(managedAgreementTO, managedAgreement);
            this.managedAgreementDAO.save(managedAgreement);
            String buffer = WSAgreementFactory.newInstance().newWSAgreementWriter().write(managedAgreementTO.getAgreement());
            this.metadataService.deleteMetadata(managedAgreement.getAgreementFile().getId());
            SimpleFile agreementFile = this.metadataService.storeMetadata(ContentType.XML, buffer.getBytes());
            managedAgreement.setAgreementFile(agreementFile);
        }
        catch (WSAgreementException e) {
            throw new SLAServiceException(e);
        }
        catch (MetadataServiceException e) {
            throw new SLAServiceException(e);
        }
        return managedAgreement.getId();
    }

    public MetadataService getMetadataService() {
        return this.metadataService;
    }

    @Override
    public List<ManagedAgreementTO> getAllManagedAgreementsFromServiceId(String serviceId) throws SLAServiceException {
        ArrayList<ManagedAgreementTO> res = new ArrayList<ManagedAgreementTO>();
        List<Endpoint> endpoints = this.endpointDAO.getAllEndpoints(serviceId);
        for (Endpoint ep : endpoints) {
            res.addAll(this.getAllManagedAgreementsFromEndpointId(ep.getId()));
        }
        return res;
    }

    @Override
    public List<ManagedAgreementTO> getAllManagedAgreementsFromEndpointId(String endpointId) throws SLAServiceException {
        ArrayList<ManagedAgreementTO> res = new ArrayList<ManagedAgreementTO>();
        try {
            ArrayList<ManagedAgreement> managedAgreements = new ArrayList<ManagedAgreement>();
            managedAgreements.addAll(this.managedAgreementDAO.getAllAgreementsFromEndpoint(endpointId));
            for (ManagedAgreement ag : managedAgreements) {
                res.add(this.slatransfertObjectAssembler.toManagedAgreementTO(ag));
            }
        }
        catch (WSAgreementException e) {
            throw new SLAServiceException(e);
        }
        return res;
    }
}

