/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.sla;

import com.ebmwebsourcing.agreement.definition.WSAgreementFactory;
import com.ebmwebsourcing.agreement.definition.api.Agreement;
import com.ebmwebsourcing.agreement.definition.api.AgreementLifeCycle;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;
import java.io.InputStream;
import org.ow2.dragon.api.service.metadata.MetadataService;
import org.ow2.dragon.api.service.metadata.MetadataServiceException;
import org.ow2.dragon.api.to.sla.ManagedAgreementTO;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.organization.Party;
import org.ow2.dragon.persistence.bo.sla.ManagedAgreement;
import org.ow2.dragon.persistence.dao.deployment.EndpointDAO;
import org.ow2.dragon.persistence.dao.organization.PartyDAO;
import org.ow2.dragon.service.sla.SLATransfertObjectAssembler;
import org.xml.sax.InputSource;

public class SLATransfertObjectAssemblerImpl
implements SLATransfertObjectAssembler {
    private MetadataService metadataService;
    private PartyDAO partyDAO;
    private EndpointDAO endpointDAO;

    @Override
    public Party getPartyBO(String id) {
        Party party = null;
        if (id != null) {
            party = (Party)this.partyDAO.get(id);
        }
        return party;
    }

    public Endpoint getEndpointBO(String id) {
        Endpoint endpoint = null;
        if (id != null) {
            endpoint = (Endpoint)this.endpointDAO.get(id);
        }
        return endpoint;
    }

    public PartyDAO getPartyDAO() {
        return this.partyDAO;
    }

    public void setPartyDAO(PartyDAO partyDAO) {
        this.partyDAO = partyDAO;
    }

    public EndpointDAO getEndpointDAO() {
        return this.endpointDAO;
    }

    public void setEndpointDAO(EndpointDAO endpointDAO) {
        this.endpointDAO = endpointDAO;
    }

    @Override
    public ManagedAgreement toManagedAgreementBO(ManagedAgreementTO maTO) throws WSAgreementException {
        ManagedAgreement maBO = new ManagedAgreement();
        maBO.setClient(this.getPartyBO(maTO.getIdClient()));
        maBO.setProvider(this.getPartyBO(maTO.getIdProvider()));
        maBO.setName(maTO.getAgreement().getName());
        if (maTO.getAgreement() instanceof AgreementLifeCycle) {
            maBO.setState(((AgreementLifeCycle)maTO.getAgreement()).getState().value());
        } else {
            maBO.setState(AgreementLifeCycle.State.OFFER_RECEIVE.value());
        }
        maBO.setEndpoint(this.getEndpointBO(maTO.getEndpointId()));
        return maBO;
    }

    @Override
    public void toManagedAgreementBO(ManagedAgreementTO maTO, ManagedAgreement maBO) throws WSAgreementException {
        maBO.setClient(this.getPartyBO(maTO.getIdClient()));
        maBO.setProvider(this.getPartyBO(maTO.getIdProvider()));
        maBO.setName(maTO.getAgreement().getName());
        if (maTO.getAgreement() instanceof AgreementLifeCycle) {
            maBO.setState(((AgreementLifeCycle)maTO.getAgreement()).getState().value());
        } else {
            maBO.setState(AgreementLifeCycle.State.OFFER_RECEIVE.value());
        }
        maBO.setEndpoint(this.getEndpointBO(maTO.getEndpointId()));
    }

    @Override
    public ManagedAgreementTO toManagedAgreementTO(ManagedAgreement maBO) throws WSAgreementException {
        ManagedAgreementTO maTO = new ManagedAgreementTO();
        maTO.setId(maBO.getId());
        if (maBO.getClient() != null) {
            maTO.setIdClient(maBO.getClient().getId());
        }
        if (maBO.getProvider() != null) {
            maTO.setIdProvider(maBO.getProvider().getId());
        }
        if (maBO.getState() == null) {
            maTO.setState(AgreementLifeCycle.State.OFFER_RECEIVE.value());
        } else {
            maTO.setState(maBO.getState());
        }
        maTO.setEndpointId(maBO.getEndpoint().getId());
        if (maBO.getAgreementFile() != null && maBO.getAgreementFile().getId() != null) {
            try {
                InputStream inputStream = this.metadataService.loadMetadataContentAsInputStream(maBO.getAgreementFile().getId());
                Agreement a = WSAgreementFactory.newInstance().newWSAgreementReader().read(new InputSource(inputStream));
                maTO.setAgreement(a);
            }
            catch (MetadataServiceException e) {
                throw new WSAgreementException((Throwable)e);
            }
        }
        return maTO;
    }

    public MetadataService getMetadataService() {
        return this.metadataService;
    }

    public void setMetadataService(MetadataService metadataService) {
        this.metadataService = metadataService;
    }
}

