/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.technology;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Logger;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.aop.annotation.CheckArgumentsNotNull;
import org.ow2.dragon.api.service.technology.TechnologyException;
import org.ow2.dragon.api.service.technology.TechnologyManager;
import org.ow2.dragon.api.service.wsdl.WSDLManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.technology.EnvironmentFederationTO;
import org.ow2.dragon.api.to.technology.ExecEnvManagerSearchProperties;
import org.ow2.dragon.api.to.technology.ExecEnvSearchProperties;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentManagerTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentTO;
import org.ow2.dragon.api.to.technology.FederationSearchProperties;
import org.ow2.dragon.api.to.technology.ProcessorSearchProperties;
import org.ow2.dragon.api.to.technology.ProcessorTO;
import org.ow2.dragon.connection.api.to.EnvironmentFederation;
import org.ow2.dragon.connection.api.to.ExecutionEnvironment;
import org.ow2.dragon.connection.api.to.ExecutionEnvironmentManager;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.technology.EnvironmentFederation;
import org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment;
import org.ow2.dragon.persistence.bo.technology.Node;
import org.ow2.dragon.persistence.bo.technology.Processor;
import org.ow2.dragon.persistence.dao.DAOLayerException;
import org.ow2.dragon.persistence.dao.GenericUnifiedDAO;
import org.ow2.dragon.persistence.dao.RequestOptions;
import org.ow2.dragon.service.TransfertObjectAssembler;
import org.ow2.dragon.service.technology.TechnologyTransferObjectAssembler;
import org.ow2.dragon.util.SearchHelper;
import org.springframework.util.CollectionUtils;

public class TechnologyManagerImpl
implements TechnologyManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private GenericUnifiedDAO<org.ow2.dragon.persistence.bo.technology.ExecutionEnvironmentManager, String> executionEnvironmentManagerUnifiedDAO;
    private GenericUnifiedDAO<org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment, String> executionEnvironmentUnifiedDAO;
    private GenericUnifiedDAO<org.ow2.dragon.persistence.bo.technology.EnvironmentFederation, String> environmentFederationUnifiedDAO;
    private GenericUnifiedDAO<Endpoint, String> endpointUnifiedDAO;
    private GenericUnifiedDAO<Processor, String> processorUnifiedDAO;
    private WSDLManager wsdlManager;
    private JaxWsProxyFactoryBean executionEnvironmentManagerFactory;
    private TransfertObjectAssembler transfertObjectAssembler;
    private TechnologyTransferObjectAssembler technologyTransferObjectAssembler;
    private final Map<String, org.ow2.dragon.connection.api.service.ExecutionEnvironmentManager> execEnvManagers = new HashMap<String, org.ow2.dragon.connection.api.service.ExecutionEnvironmentManager>();

    @Override
    @CheckAllArgumentsNotNull
    public String addRuntimeManager(String address) throws TechnologyException {
        String result = null;
        try {
            new URL(address);
        }
        catch (MalformedURLException e) {
            throw new TechnologyException("Bad URL", e);
        }
        List<org.ow2.dragon.persistence.bo.technology.ExecutionEnvironmentManager> execEnvManagers = this.executionEnvironmentManagerUnifiedDAO.searchEquals(new String[]{address}, new String[]{"address"}, null);
        if (CollectionUtils.isEmpty(execEnvManagers)) {
            org.ow2.dragon.connection.api.service.ExecutionEnvironmentManager execEnvManagerProxy = this.createExecEnvManagerProxy(address);
            ExecutionEnvironmentManager execEnvManagerTO = execEnvManagerProxy.getProperties();
            if (execEnvManagerTO == null) {
                throw new TechnologyException("Can't retrieve execution environment manager properties");
            }
            org.ow2.dragon.persistence.bo.technology.ExecutionEnvironmentManager execEnvManagerBO = new org.ow2.dragon.persistence.bo.technology.ExecutionEnvironmentManager();
            execEnvManagerBO.setAddress(address);
            execEnvManagerBO.setName(execEnvManagerTO.getName());
            result = this.executionEnvironmentManagerUnifiedDAO.save(execEnvManagerBO).getId();
        } else {
            if (execEnvManagers.size() > 1) {
                throw new TechnologyException("Database incoherence : two or more Execution Environment Manager with the same address");
            }
            result = execEnvManagers.get(0).getId();
        }
        return result;
    }

    private org.ow2.dragon.connection.api.service.ExecutionEnvironmentManager createExecEnvManagerProxy(String address) throws TechnologyException {
        org.ow2.dragon.connection.api.service.ExecutionEnvironmentManager execEnvManagerProxy = this.execEnvManagers.get(address);
        if (execEnvManagerProxy == null) {
            ClientFactoryBean clientFactoryBean = this.executionEnvironmentManagerFactory.getClientFactoryBean();
            this.executionEnvironmentManagerFactory.setAddress(address);
            try {
                execEnvManagerProxy = (org.ow2.dragon.connection.api.service.ExecutionEnvironmentManager)this.executionEnvironmentManagerFactory.create();
            }
            catch (RuntimeException e) {
                throw new TechnologyException("Can't connect to execution environment manager");
            }
            this.execEnvManagers.put(address, execEnvManagerProxy);
        }
        return execEnvManagerProxy;
    }

    @Override
    @CheckArgumentsNotNull
    public List<ExecutionEnvironmentTO> getManagedExecEnv(String runtimeManagerId, RequestOptionsTO requestOptionsTO) {
        ArrayList<ExecutionEnvironmentTO> result = new ArrayList<ExecutionEnvironmentTO>();
        List<org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment> execEnvsBO = this.executionEnvironmentUnifiedDAO.searchEquals(new String[]{runtimeManagerId}, new String[]{"manager.id"}, this.transfertObjectAssembler.toExecEnvRequestOptions(requestOptionsTO));
        if (execEnvsBO != null) {
            for (org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment execEnvBO : execEnvsBO) {
                result.add(this.technologyTransferObjectAssembler.toExecutionEnvironmentTO(execEnvBO));
            }
        }
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public void synchronizeManagedExecEnv(String runtimeManagerId) throws TechnologyException {
        org.ow2.dragon.persistence.bo.technology.ExecutionEnvironmentManager executionEnvironmentManager = this.executionEnvironmentManagerUnifiedDAO.get(runtimeManagerId);
        if (executionEnvironmentManager == null) {
            throw new TechnologyException("Can't retrieve Execution Environment Manager with id: " + runtimeManagerId);
        }
        org.ow2.dragon.connection.api.service.ExecutionEnvironmentManager execEnvManagerProxy = this.createExecEnvManagerProxy(executionEnvironmentManager.getAddress());
        List execEnvProxies = execEnvManagerProxy.getManagedExecutionEnvironments();
        if (!CollectionUtils.isEmpty((Collection)execEnvProxies)) {
            for (ExecutionEnvironment execEnvProxy : execEnvProxies) {
                RequestOptions requestOptions = new RequestOptions();
                requestOptions.setCaseSensitive(true);
                List<org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment> execEnvsBO = this.executionEnvironmentUnifiedDAO.searchEquals(new String[]{execEnvProxy.getName()}, new String[]{"name"}, requestOptions);
                org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment execEnvBO = null;
                if (!CollectionUtils.isEmpty(execEnvsBO)) {
                    if (execEnvsBO.size() > 1) {
                        throw new TechnologyException("Database incoherence : two or more Execution Environment with the same name");
                    }
                    execEnvBO = execEnvsBO.get(0);
                    this.updateExecEnv(execEnvProxy, execEnvBO);
                } else {
                    execEnvBO = this.createNewExecEnv(executionEnvironmentManager, execEnvProxy);
                }
                executionEnvironmentManager.addNode(execEnvBO);
            }
        }
        this.executionEnvironmentManagerUnifiedDAO.save(executionEnvironmentManager);
    }

    private org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment createNewExecEnv(org.ow2.dragon.persistence.bo.technology.ExecutionEnvironmentManager executionEnvironmentManager, ExecutionEnvironment execEnvProxy) throws TechnologyException {
        org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment execEnvBO = new org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment();
        ExecutionEnvironment.EEType type = execEnvProxy.getEnvType();
        if (type != null) {
            execEnvBO.setEnvType(ExecutionEnvironment.EEType.valueOf(type.toString()));
        }
        execEnvBO.setIpv4Address(execEnvProxy.getIpv4Address());
        execEnvBO.setName(execEnvProxy.getName());
        execEnvBO.setRoleInFederation(execEnvProxy.getRoleInFederation());
        execEnvBO.setType(execEnvProxy.getType());
        this.executionEnvironmentUnifiedDAO.save(execEnvBO);
        this.setEnpoints(execEnvProxy, execEnvBO);
        this.setHostProcessor(execEnvProxy, execEnvBO);
        this.setParentFederation(execEnvProxy, execEnvBO);
        this.executionEnvironmentUnifiedDAO.save(execEnvBO);
        return execEnvBO;
    }

    private void setParentFederation(ExecutionEnvironment execEnvProxy, org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment execEnvBO) throws TechnologyException {
        EnvironmentFederation federationProxy = execEnvProxy.getParentFederation();
        if (federationProxy != null) {
            org.ow2.dragon.persistence.bo.technology.EnvironmentFederation envFedBO;
            RequestOptions requestOptions = new RequestOptions();
            requestOptions.setCaseSensitive(true);
            List<org.ow2.dragon.persistence.bo.technology.EnvironmentFederation> envFedsBO = this.environmentFederationUnifiedDAO.searchEquals(new String[]{execEnvProxy.getParentFederation().getName().toString()}, new String[]{"name"}, requestOptions);
            if (!CollectionUtils.isEmpty(envFedsBO)) {
                if (envFedsBO.size() > 1) {
                    throw new TechnologyException("Database incoherence : two or more Environment Federations with the same name");
                }
                envFedBO = envFedsBO.get(0);
                this.updateEnvFed(federationProxy, envFedBO);
            } else {
                envFedBO = this.createNewEnvFed(federationProxy, execEnvBO);
            }
            envFedBO.addExecEnv(execEnvBO);
        }
    }

    private org.ow2.dragon.persistence.bo.technology.EnvironmentFederation createNewEnvFed(EnvironmentFederation federationProxy, org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment execEnvBO) {
        List possibleRoles;
        org.ow2.dragon.persistence.bo.technology.EnvironmentFederation environmentFederation = new org.ow2.dragon.persistence.bo.technology.EnvironmentFederation();
        environmentFederation.setName(federationProxy.getName());
        EnvironmentFederation.FedPattern pattern = federationProxy.getPattern();
        if (pattern != null) {
            environmentFederation.setPattern(EnvironmentFederation.FedPattern.valueOf(pattern.toString()));
        }
        if (!CollectionUtils.isEmpty((Collection)(possibleRoles = federationProxy.getPossibleRole()))) {
            for (String possibleRole : possibleRoles) {
                environmentFederation.addPossibleRole(possibleRole);
            }
        }
        this.environmentFederationUnifiedDAO.save(environmentFederation);
        return environmentFederation;
    }

    private void updateEnvFed(EnvironmentFederation federationProxy, org.ow2.dragon.persistence.bo.technology.EnvironmentFederation envFedBO) {
        List possibleRoles;
        EnvironmentFederation.FedPattern pattern = federationProxy.getPattern();
        if (pattern != null) {
            envFedBO.setPattern(EnvironmentFederation.FedPattern.valueOf(pattern.toString()));
        }
        if (!CollectionUtils.isEmpty((Collection)(possibleRoles = federationProxy.getPossibleRole()))) {
            for (String possibleRole : possibleRoles) {
                envFedBO.addPossibleRole(possibleRole);
            }
        }
        this.environmentFederationUnifiedDAO.save(envFedBO);
    }

    private void setHostProcessor(ExecutionEnvironment execEnvProxy, org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment execEnvBO) throws TechnologyException {
        org.ow2.dragon.connection.api.to.Processor processorProxy = execEnvProxy.getHostProcessor();
        if (processorProxy != null) {
            Processor processorBO;
            RequestOptions requestOptions = new RequestOptions();
            requestOptions.setCaseSensitive(true);
            List<Processor> processorsBO = this.processorUnifiedDAO.searchEquals(new String[]{execEnvProxy.getHostProcessor().getName().toString()}, new String[]{"name"}, requestOptions);
            if (!CollectionUtils.isEmpty(processorsBO)) {
                if (processorsBO.size() > 1) {
                    throw new TechnologyException("Database incoherence : two or more Processors with the same name");
                }
                processorBO = processorsBO.get(0);
                this.updateProcessor(processorProxy, processorBO);
            } else {
                processorBO = this.createNewProcessor(processorProxy, execEnvBO);
            }
            processorBO.addExecutionEnvironment(execEnvBO);
        }
    }

    private Processor createNewProcessor(org.ow2.dragon.connection.api.to.Processor processorProxy, org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment execEnvBO) {
        Processor processor = new Processor();
        processor.setName(processorProxy.getName());
        processor.setIpv4Address(processorProxy.getIpv4Address());
        processor.setType(processorProxy.getType());
        this.processorUnifiedDAO.save(processor);
        return processor;
    }

    private void updateProcessor(org.ow2.dragon.connection.api.to.Processor processorProxy, Processor processorBO) {
        processorBO.setIpv4Address(processorProxy.getIpv4Address());
        processorBO.setType(processorProxy.getType());
        this.processorUnifiedDAO.save(processorBO);
    }

    private void setEnpoints(ExecutionEnvironment execEnvProxy, org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment execEnvBO) throws TechnologyException {
        List epsProxy = execEnvProxy.getEndpoints();
        if (!CollectionUtils.isEmpty((Collection)epsProxy)) {
            for (org.ow2.dragon.connection.api.to.Endpoint epProxy : epsProxy) {
                Endpoint epBO;
                RequestOptions requestOptions = new RequestOptions();
                requestOptions.setCaseSensitive(true);
                List<Endpoint> epsBO = this.endpointUnifiedDAO.searchEquals(new String[]{epProxy.getName().toString()}, new String[]{"name"}, requestOptions);
                if (!CollectionUtils.isEmpty(epsBO)) {
                    if (epsBO.size() > 1) {
                        throw new TechnologyException("Database incoherence : two or more Endpoints with the same name");
                    }
                    epBO = epsBO.get(0);
                    this.updateEndpoint(epProxy, epBO);
                } else {
                    epBO = this.createNewEndpoint(epProxy);
                }
                if (epBO == null) continue;
                execEnvBO.addEndpoint(epBO);
            }
        }
    }

    private Endpoint createNewEndpoint(org.ow2.dragon.connection.api.to.Endpoint epProxy) throws TechnologyException {
        Endpoint result = null;
        QName epName = epProxy.getName();
        if (epName == null) {
            throw new TechnologyException("Can't register an Endpoint without name");
        }
        try {
            this.wsdlManager.importServiceDefFile(epProxy.getWsdlDescription(), epProxy.getWsdlDescriptionImports(), null);
        }
        catch (Exception e) {
            this.logger.warn((Object)("Failed to import endpoint description for ep:'" + epName.toString() + "'. Endpoint will not be managed !"), (Throwable)e);
        }
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setCaseSensitive(true);
        List<Endpoint> epsBO = this.endpointUnifiedDAO.searchEquals(new String[]{epName.toString()}, new String[]{"name"}, requestOptions);
        if (!CollectionUtils.isEmpty(epsBO)) {
            result = epsBO.get(0);
        } else {
            this.logger.warn((Object)("You are trying to register an Endpoint without description: " + epName.toString()));
        }
        return result;
    }

    private void updateEndpoint(org.ow2.dragon.connection.api.to.Endpoint epProxy, Endpoint epBO) {
    }

    private void updateExecEnv(ExecutionEnvironment execEnvProxy, org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment executionEnvironment) throws TechnologyException {
        ExecutionEnvironment.EEType type = execEnvProxy.getEnvType();
        if (type != null) {
            executionEnvironment.setEnvType(ExecutionEnvironment.EEType.valueOf(type.toString()));
        }
        executionEnvironment.setIpv4Address(execEnvProxy.getIpv4Address());
        executionEnvironment.setRoleInFederation(execEnvProxy.getRoleInFederation());
        executionEnvironment.setType(execEnvProxy.getType());
        this.setEnpoints(execEnvProxy, executionEnvironment);
        this.setHostProcessor(execEnvProxy, executionEnvironment);
        this.setParentFederation(execEnvProxy, executionEnvironment);
        this.executionEnvironmentUnifiedDAO.save(executionEnvironment);
    }

    public void setExecutionEnvironmentManagerUnifiedDAO(GenericUnifiedDAO<org.ow2.dragon.persistence.bo.technology.ExecutionEnvironmentManager, String> executionEnvironmentManagerUnifiedDAO) {
        this.executionEnvironmentManagerUnifiedDAO = executionEnvironmentManagerUnifiedDAO;
    }

    public void setExecutionEnvironmentUnifiedDAO(GenericUnifiedDAO<org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment, String> executionEnvironmentUnifiedDAO) {
        this.executionEnvironmentUnifiedDAO = executionEnvironmentUnifiedDAO;
    }

    public void setExecutionEnvironmentManagerFactory(JaxWsProxyFactoryBean executionEnvironmentManagerFactory) {
        this.executionEnvironmentManagerFactory = executionEnvironmentManagerFactory;
    }

    public void setTransfertObjectAssembler(TransfertObjectAssembler transfertObjectAssembler) {
        this.transfertObjectAssembler = transfertObjectAssembler;
    }

    public void setTechnologyTransferObjectAssembler(TechnologyTransferObjectAssembler technologyTransferObjectAssembler) {
        this.technologyTransferObjectAssembler = technologyTransferObjectAssembler;
    }

    @Override
    @CheckAllArgumentsNotNull
    public ExecutionEnvironmentManagerTO getRuntimeManager(String runtimeManagerId) throws TechnologyException {
        org.ow2.dragon.persistence.bo.technology.ExecutionEnvironmentManager environmentManager = this.executionEnvironmentManagerUnifiedDAO.get(runtimeManagerId);
        if (environmentManager == null) {
            throw new TechnologyException("No runtime manager found for the given id: " + runtimeManagerId);
        }
        return this.technologyTransferObjectAssembler.toExecutionEnvironmentManagerTO(environmentManager);
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeRuntimeManager(String runtimeManagerId) throws TechnologyException {
        org.ow2.dragon.persistence.bo.technology.ExecutionEnvironmentManager environmentManager = this.executionEnvironmentManagerUnifiedDAO.get(runtimeManagerId);
        if (environmentManager == null) {
            throw new TechnologyException("No execution environment matching the given id: " + runtimeManagerId);
        }
        Set<Node> nodes = environmentManager.getManagedNodes();
        if (nodes != null) {
            for (Node node : nodes) {
                node.setManager(null);
                if (node instanceof org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment) {
                    this.executionEnvironmentUnifiedDAO.save((org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment)node);
                    continue;
                }
                this.processorUnifiedDAO.save((Processor)node);
            }
        }
        this.executionEnvironmentManagerUnifiedDAO.remove(environmentManager);
    }

    @Override
    @CheckAllArgumentsNotNull
    public ExecutionEnvironmentTO getExecutionEnvironment(String execEnvId) throws TechnologyException {
        org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment environment = this.executionEnvironmentUnifiedDAO.get(execEnvId);
        if (environment == null) {
            throw new TechnologyException("No execution environment found for the given id: " + execEnvId);
        }
        return this.technologyTransferObjectAssembler.toExecutionEnvironmentTO(environment);
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeExecutionEnvironment(String execEnvId) throws TechnologyException {
        org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment executionEnvironment = this.executionEnvironmentUnifiedDAO.get(execEnvId);
        if (executionEnvironment == null) {
            throw new TechnologyException("No execution environment matching the given id: " + execEnvId);
        }
        Set<Endpoint> endpoints = executionEnvironment.getEndpoints();
        if (endpoints != null) {
            for (Endpoint endpoint : endpoints) {
                endpoint.setHostNode(null);
                this.endpointUnifiedDAO.save(endpoint);
            }
        }
        this.executionEnvironmentUnifiedDAO.remove((org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment)((Object)execEnvId));
    }

    public void setEndpointUnifiedDAO(GenericUnifiedDAO<Endpoint, String> endpointUnifiedDAO) {
        this.endpointUnifiedDAO = endpointUnifiedDAO;
    }

    public void setWsdlManager(WSDLManager wsdlManager) {
        this.wsdlManager = wsdlManager;
    }

    @Override
    public List<ExecutionEnvironmentManagerTO> getAllExecutionEnvironmentManagers(RequestOptionsTO requestOptionsTO) {
        ArrayList<ExecutionEnvironmentManagerTO> result = new ArrayList<ExecutionEnvironmentManagerTO>();
        List<org.ow2.dragon.persistence.bo.technology.ExecutionEnvironmentManager> runtimeManagers = this.executionEnvironmentManagerUnifiedDAO.getAll(this.transfertObjectAssembler.toExecEnvManRequestOptions(requestOptionsTO));
        this.toRuntimeManagersTO(result, runtimeManagers);
        return result;
    }

    private void toRuntimeManagersTO(List<ExecutionEnvironmentManagerTO> result, List<org.ow2.dragon.persistence.bo.technology.ExecutionEnvironmentManager> runtimeManagers) {
        if (runtimeManagers != null && !runtimeManagers.isEmpty()) {
            for (org.ow2.dragon.persistence.bo.technology.ExecutionEnvironmentManager runtimeManager : runtimeManagers) {
                result.add(this.toRuntimeManagerTO(runtimeManager));
            }
        }
    }

    private ExecutionEnvironmentManagerTO toRuntimeManagerTO(org.ow2.dragon.persistence.bo.technology.ExecutionEnvironmentManager runtimeManager) {
        return this.technologyTransferObjectAssembler.toExecutionEnvironmentManagerTO(runtimeManager);
    }

    @Override
    @CheckArgumentsNotNull
    public List<ExecutionEnvironmentManagerTO> searchExecutionEnvironmentManagers(String searchCriteria, List<ExecEnvManagerSearchProperties> searchedProperties, RequestOptionsTO requestOptionsTO) throws TechnologyException {
        List<org.ow2.dragon.persistence.bo.technology.ExecutionEnvironmentManager> runtimeManagers;
        ArrayList<ExecutionEnvironmentManagerTO> result = new ArrayList<ExecutionEnvironmentManagerTO>();
        String[] criteria = SearchHelper.splitSearchCriteria((String)searchCriteria);
        String[] properties = this.createRuntimeManagerSearchProperties(searchedProperties);
        try {
            runtimeManagers = this.executionEnvironmentManagerUnifiedDAO.searchORMResult(criteria, properties, this.transfertObjectAssembler.toExecEnvManRequestOptions(requestOptionsTO));
        }
        catch (DAOLayerException e) {
            throw new TechnologyException("You must specified non empty search criteria and properties.", e);
        }
        this.toRuntimeManagersTO(result, runtimeManagers);
        return result;
    }

    private String[] createRuntimeManagerSearchProperties(List<ExecEnvManagerSearchProperties> searchedProperties) {
        ArrayList<String> propertiesList = new ArrayList<String>();
        if (searchedProperties != null && !searchedProperties.isEmpty()) {
            if (searchedProperties.contains((Object)ExecEnvManagerSearchProperties.NAME)) {
                propertiesList.add("name");
            }
        } else {
            propertiesList.add("name");
        }
        return propertiesList.toArray(new String[0]);
    }

    @Override
    public List<ExecutionEnvironmentTO> getAllExecutionEnvironments(RequestOptionsTO requestOptionsTO) {
        ArrayList<ExecutionEnvironmentTO> result = new ArrayList<ExecutionEnvironmentTO>();
        List<org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment> execEnvs = this.executionEnvironmentUnifiedDAO.getAll(this.transfertObjectAssembler.toExecEnvRequestOptions(requestOptionsTO));
        this.toExecEnvsTO(result, execEnvs);
        return result;
    }

    private void toExecEnvsTO(List<ExecutionEnvironmentTO> result, List<org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment> execEnvs) {
        if (execEnvs != null && !execEnvs.isEmpty()) {
            for (org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment execEnv : execEnvs) {
                result.add(this.toExecEnvTO(execEnv));
            }
        }
    }

    private ExecutionEnvironmentTO toExecEnvTO(org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment execEnv) {
        return this.technologyTransferObjectAssembler.toExecutionEnvironmentTO(execEnv);
    }

    @Override
    @CheckArgumentsNotNull
    public List<ExecutionEnvironmentTO> searchExecutionEnvironments(String searchCriteria, List<ExecEnvSearchProperties> searchedProperties, RequestOptionsTO requestOptionsTO) throws TechnologyException {
        List<org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment> execEnvs;
        ArrayList<ExecutionEnvironmentTO> result = new ArrayList<ExecutionEnvironmentTO>();
        String[] criteria = SearchHelper.splitSearchCriteria((String)searchCriteria);
        String[] properties = this.createExecEnvSearchProperties(searchedProperties);
        try {
            execEnvs = this.executionEnvironmentUnifiedDAO.searchORMResult(criteria, properties, this.transfertObjectAssembler.toExecEnvRequestOptions(requestOptionsTO));
        }
        catch (DAOLayerException e) {
            throw new TechnologyException("You must specified non empty search criteria and properties.", e);
        }
        this.toExecEnvsTO(result, execEnvs);
        return result;
    }

    private String[] createExecEnvSearchProperties(List<ExecEnvSearchProperties> searchedProperties) {
        ArrayList<String> propertiesList = new ArrayList<String>();
        if (searchedProperties != null && !searchedProperties.isEmpty()) {
            if (searchedProperties.contains((Object)ExecEnvSearchProperties.NAME)) {
                propertiesList.add("name");
            }
            if (searchedProperties.contains((Object)ExecEnvSearchProperties.ENV_TYPE)) {
                propertiesList.add("envType");
            }
            if (searchedProperties.contains((Object)ExecEnvSearchProperties.ADDRESS)) {
                propertiesList.add("ipv4Address");
            }
            if (searchedProperties.contains((Object)ExecEnvSearchProperties.ROLE_IN_FEDERATION)) {
                propertiesList.add("roleInFederation");
            }
            if (searchedProperties.contains((Object)ExecEnvSearchProperties.FEDERATION)) {
                propertiesList.add("parentFederation.name");
            }
            if (searchedProperties.contains((Object)ExecEnvSearchProperties.HOST)) {
                propertiesList.add("hostProcessor.name");
            }
        } else {
            propertiesList.add("name");
            propertiesList.add("envType");
            propertiesList.add("ipv4Address");
            propertiesList.add("roleInFederation");
            propertiesList.add("parentFederation.name");
            propertiesList.add("hostProcessor.name");
        }
        return propertiesList.toArray(new String[0]);
    }

    @Override
    @CheckArgumentsNotNull
    public List<EndpointTO> getEpsHostedOnExecEnv(String execEnvId, RequestOptionsTO requestOptionsTO) {
        ArrayList<EndpointTO> result = new ArrayList<EndpointTO>();
        List<Endpoint> epsBO = this.endpointUnifiedDAO.searchEquals(new String[]{execEnvId}, new String[]{"hostNode.id"}, this.transfertObjectAssembler.toEndpointRequestOptions(requestOptionsTO));
        if (epsBO != null) {
            for (Endpoint epBO : epsBO) {
                result.add(this.transfertObjectAssembler.toEndpointTO(epBO, null));
            }
        }
        return result;
    }

    @Override
    @CheckArgumentsNotNull
    public List<EndpointTO> getEpsHostedOnProcessor(String processorId, RequestOptionsTO requestOptionsTO) {
        ArrayList<EndpointTO> result = new ArrayList<EndpointTO>();
        List<Endpoint> epsBO = this.endpointUnifiedDAO.searchEquals(new String[]{processorId}, new String[]{"hostNode.hostProcessor.id"}, this.transfertObjectAssembler.toEndpointRequestOptions(requestOptionsTO));
        if (epsBO != null) {
            for (Endpoint epBO : epsBO) {
                result.add(this.transfertObjectAssembler.toEndpointTO(epBO, null));
            }
        }
        return result;
    }

    @Override
    @CheckArgumentsNotNull
    public List<ExecutionEnvironmentTO> getExecEnvsHostedOnProcessor(String processorId, RequestOptionsTO requestOptionsTO) {
        ArrayList<ExecutionEnvironmentTO> result = new ArrayList<ExecutionEnvironmentTO>();
        List<org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment> execEnvsBO = this.executionEnvironmentUnifiedDAO.searchEquals(new String[]{processorId}, new String[]{"hostProcessor.id"}, this.transfertObjectAssembler.toExecEnvRequestOptions(requestOptionsTO));
        if (execEnvsBO != null) {
            for (org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment execEnvBO : execEnvsBO) {
                result.add(this.technologyTransferObjectAssembler.toExecutionEnvironmentTO(execEnvBO));
            }
        }
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public ProcessorTO getProcessor(String processorId) throws TechnologyException {
        Processor processor = this.processorUnifiedDAO.get(processorId);
        if (processor == null) {
            throw new TechnologyException("No processor found for the given id: " + processorId);
        }
        return this.technologyTransferObjectAssembler.toProcessorTO(processor);
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeProcessor(String processorId) throws TechnologyException {
        Set<org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment> executionEnvironments;
        Processor processor = this.processorUnifiedDAO.get(processorId);
        if (processor == null) {
            throw new TechnologyException("No processor matching the given id: " + processorId);
        }
        Set<Endpoint> endpoints = processor.getEndpoints();
        if (endpoints != null) {
            for (Endpoint endpoint : endpoints) {
                endpoint.setHostNode(null);
                this.endpointUnifiedDAO.save(endpoint);
            }
        }
        if ((executionEnvironments = processor.getExecutionEnvs()) != null) {
            for (org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment executionEnvironment : executionEnvironments) {
                executionEnvironment.setHostProcessor(null);
                this.executionEnvironmentUnifiedDAO.save(executionEnvironment);
            }
        }
        this.processorUnifiedDAO.remove(processor);
    }

    public void setProcessorUnifiedDAO(GenericUnifiedDAO<Processor, String> processorUnifiedDAO) {
        this.processorUnifiedDAO = processorUnifiedDAO;
    }

    @Override
    public List<ProcessorTO> getAllProcessors(RequestOptionsTO requestOptionsTO) {
        ArrayList<ProcessorTO> result = new ArrayList<ProcessorTO>();
        List<Processor> processors = this.processorUnifiedDAO.getAll(this.transfertObjectAssembler.toProcessorRequestOptions(requestOptionsTO));
        this.toProcessorsTO(result, processors);
        return result;
    }

    private void toProcessorsTO(List<ProcessorTO> result, List<Processor> processors) {
        if (processors != null && !processors.isEmpty()) {
            for (Processor processor : processors) {
                result.add(this.toProcessorTO(processor));
            }
        }
    }

    private ProcessorTO toProcessorTO(Processor processor) {
        return this.technologyTransferObjectAssembler.toProcessorTO(processor);
    }

    @Override
    @CheckArgumentsNotNull
    public List<ProcessorTO> searchProcessors(String searchCriteria, List<ProcessorSearchProperties> searchedProperties, RequestOptionsTO requestOptionsTO) throws TechnologyException {
        List<Processor> processors;
        ArrayList<ProcessorTO> result = new ArrayList<ProcessorTO>();
        String[] criteria = SearchHelper.splitSearchCriteria((String)searchCriteria);
        String[] properties = this.createProcessorSearchProperties(searchedProperties);
        try {
            processors = this.processorUnifiedDAO.searchORMResult(criteria, properties, this.transfertObjectAssembler.toProcessorRequestOptions(requestOptionsTO));
        }
        catch (DAOLayerException e) {
            throw new TechnologyException("You must specified non empty search criteria and properties.", e);
        }
        this.toProcessorsTO(result, processors);
        return result;
    }

    private String[] createProcessorSearchProperties(List<ProcessorSearchProperties> searchedProperties) {
        ArrayList<String> propertiesList = new ArrayList<String>();
        if (searchedProperties != null && !searchedProperties.isEmpty()) {
            if (searchedProperties.contains((Object)ProcessorSearchProperties.NAME)) {
                propertiesList.add("name");
            }
            if (searchedProperties.contains((Object)ProcessorSearchProperties.ADDRESS)) {
                propertiesList.add("ipv4Address");
            }
        } else {
            propertiesList.add("name");
            propertiesList.add("ipv4Address");
        }
        return propertiesList.toArray(new String[0]);
    }

    @Override
    @CheckAllArgumentsNotNull
    public EnvironmentFederationTO getEnvironmentFederation(String envFedId) throws TechnologyException {
        org.ow2.dragon.persistence.bo.technology.EnvironmentFederation environmentFederation = this.environmentFederationUnifiedDAO.get(envFedId);
        if (environmentFederation == null) {
            throw new TechnologyException("No environment federation found for the given ID: " + envFedId);
        }
        return this.technologyTransferObjectAssembler.toEnvironmentFederationTO(environmentFederation);
    }

    @Override
    @CheckArgumentsNotNull
    public List<ExecutionEnvironmentTO> getExecEnvsInFederation(String envFedId, RequestOptionsTO requestOptionsTO) {
        ArrayList<ExecutionEnvironmentTO> result = new ArrayList<ExecutionEnvironmentTO>();
        List<org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment> execEnvsBO = this.executionEnvironmentUnifiedDAO.searchEquals(new String[]{envFedId}, new String[]{"parentFederation.id"}, this.transfertObjectAssembler.toExecEnvRequestOptions(requestOptionsTO));
        if (execEnvsBO != null) {
            for (org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment execEnvBO : execEnvsBO) {
                result.add(this.technologyTransferObjectAssembler.toExecutionEnvironmentTO(execEnvBO));
            }
        }
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeEnvironmentFederation(String envFedId) throws TechnologyException {
        org.ow2.dragon.persistence.bo.technology.EnvironmentFederation federation = this.environmentFederationUnifiedDAO.get(envFedId);
        if (federation == null) {
            throw new TechnologyException("No federation matching the given id: " + envFedId);
        }
        Set<org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment> executionEnvironments = federation.getExecEnvs();
        if (executionEnvironments != null) {
            for (org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment executionEnvironment : executionEnvironments) {
                executionEnvironment.setParentFederation(null);
                this.executionEnvironmentUnifiedDAO.save(executionEnvironment);
            }
        }
        this.environmentFederationUnifiedDAO.remove(federation);
    }

    public void setEnvironmentFederationUnifiedDAO(GenericUnifiedDAO<org.ow2.dragon.persistence.bo.technology.EnvironmentFederation, String> environmentFederationUnifiedDAO) {
        this.environmentFederationUnifiedDAO = environmentFederationUnifiedDAO;
    }

    @Override
    public List<EnvironmentFederationTO> getAllEnvironmentFederations(RequestOptionsTO requestOptionsTO) {
        ArrayList<EnvironmentFederationTO> result = new ArrayList<EnvironmentFederationTO>();
        List<org.ow2.dragon.persistence.bo.technology.EnvironmentFederation> envFeds = this.environmentFederationUnifiedDAO.getAll(this.transfertObjectAssembler.toFederationRequestOptions(requestOptionsTO));
        this.toEnvFedsTO(result, envFeds);
        return result;
    }

    private void toEnvFedsTO(List<EnvironmentFederationTO> result, List<org.ow2.dragon.persistence.bo.technology.EnvironmentFederation> envFeds) {
        if (!CollectionUtils.isEmpty(envFeds)) {
            for (org.ow2.dragon.persistence.bo.technology.EnvironmentFederation envFed : envFeds) {
                result.add(this.toEnvFedTO(envFed));
            }
        }
    }

    private EnvironmentFederationTO toEnvFedTO(org.ow2.dragon.persistence.bo.technology.EnvironmentFederation envFed) {
        return this.technologyTransferObjectAssembler.toEnvironmentFederationTO(envFed);
    }

    @Override
    @CheckArgumentsNotNull
    public List<EnvironmentFederationTO> searchEnvironmentFederations(String searchCriteria, List<FederationSearchProperties> searchedProperties, RequestOptionsTO requestOptionsTO) throws TechnologyException {
        List<org.ow2.dragon.persistence.bo.technology.EnvironmentFederation> envFeds;
        ArrayList<EnvironmentFederationTO> result = new ArrayList<EnvironmentFederationTO>();
        String[] criteria = SearchHelper.splitSearchCriteria((String)searchCriteria);
        String[] properties = this.createEnvFedSearchProperties(searchedProperties);
        try {
            envFeds = this.environmentFederationUnifiedDAO.searchORMResult(criteria, properties, this.transfertObjectAssembler.toFederationRequestOptions(requestOptionsTO));
        }
        catch (DAOLayerException e) {
            throw new TechnologyException("You must specified non empty search criteria and properties.", e);
        }
        this.toEnvFedsTO(result, envFeds);
        return result;
    }

    private String[] createEnvFedSearchProperties(List<FederationSearchProperties> searchedProperties) {
        ArrayList<String> propertiesList = new ArrayList<String>();
        if (searchedProperties != null && !searchedProperties.isEmpty()) {
            if (searchedProperties.contains((Object)FederationSearchProperties.NAME)) {
                propertiesList.add("name");
            }
            if (searchedProperties.contains((Object)FederationSearchProperties.PATTERN)) {
                propertiesList.add("pattern");
            }
        } else {
            propertiesList.add("name");
            propertiesList.add("pattern");
        }
        return propertiesList.toArray(new String[0]);
    }
}

