/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.wsdm;

import com.ebmwebsourcing.wsstar.dm.api.QoSMetrics;
import com.ebmwebsourcing.wsstar.dm.api.WSDMException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Set;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.wsdm.NotificationManager;
import org.ow2.dragon.api.to.wsdm.QoSMetricTO;
import org.ow2.dragon.persistence.bo.deployment.Binding;
import org.ow2.dragon.persistence.bo.deployment.BindingOperation;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.wsdm.QoSMetric;
import org.ow2.dragon.persistence.dao.deployment.EndpointDAO;
import org.ow2.dragon.persistence.dao.wsdm.QoSMetricDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;

public class NotificationManagerImpl
implements NotificationManager {
    private Logger logger = Logger.getLogger(this.getClass());
    private QoSMetricDAO qoSMetricDAO;
    private TransfertObjectAssembler transfertObjectAssembler;
    private EndpointDAO endpointDAO;

    @Override
    public void handleNotification(QoSMetrics metric, String endpointRef) {
        QoSMetricTO metricTO = this.transformQoSMetrics(metric, endpointRef);
        this.storeQoSMetrics(metricTO);
    }

    private void storeQoSMetrics(QoSMetricTO metricTO) {
        QoSMetric metricBO = new QoSMetric();
        this.transfertObjectAssembler.toQoSMetricBO(metricTO, metricBO);
        this.qoSMetricDAO.save(metricBO);
    }

    private QoSMetricTO transformQoSMetrics(QoSMetrics metric, String endpointRef) {
        QoSMetricTO metricTO = null;
        try {
            metricTO = this.convertQoSMetrics(metric, endpointRef);
        }
        catch (WSDMException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return metricTO;
    }

    private QoSMetricTO convertQoSMetrics(QoSMetrics metric, String endpointRef) throws WSDMException {
        Set<BindingOperation> set;
        Calendar calendar = GregorianCalendar.getInstance();
        QoSMetricTO metricTO = new QoSMetricTO();
        if (metric.getLastRequestSize() != null && metric.getLastRequestSize().getValue() != null) {
            metricTO.setLastRequestSize(((Integer)metric.getLastRequestSize().getValue()).intValue());
        }
        if (metric.getLastResponseSize() != null && metric.getLastResponseSize().getValue() != null) {
            metricTO.setLastResponseSize(((Integer)metric.getLastResponseSize().getValue()).intValue());
        }
        if (metric.getMaxRequestSize() != null && metric.getMaxRequestSize().getValue() != null) {
            metricTO.setMaxRequestSize(((Integer)metric.getMaxRequestSize().getValue()).intValue());
        }
        if (metric.getMaxResponseSize() != null && metric.getMaxResponseSize().getValue() != null) {
            metricTO.setMaxResponseSize(((Integer)metric.getMaxResponseSize().getValue()).intValue());
        }
        if (metric.getNumberOfFailedRequests() != null && metric.getNumberOfFailedRequests().getValue() != null) {
            metricTO.setNumberOfFailedRequest(((Integer)metric.getNumberOfFailedRequests().getValue()).intValue());
        }
        if (metric.getNumberOfRequests() != null && metric.getNumberOfRequests().getValue() != null) {
            metricTO.setNumberOfRequests(((Integer)metric.getNumberOfRequests().getValue()).intValue());
        }
        if (metric.getNumberOfSuccessfulRequests() != null && metric.getNumberOfSuccessfulRequests().getValue() != null) {
            metricTO.setNumberOfSuccessfulRequest(((Integer)metric.getNumberOfSuccessfulRequests().getValue()).intValue());
        }
        if (metric.getLastResponseTime() != null && metric.getLastResponseTime().getValue() != null) {
            metricTO.setLastResponseTime(((Duration)metric.getLastResponseTime().getValue()).getTimeInMillis(calendar));
        }
        if (metric.getMaxResponseTime() != null && metric.getMaxResponseTime().getValue() != null) {
            metricTO.setMaxResponseTime(((Duration)metric.getMaxResponseTime().getValue()).getTimeInMillis(calendar));
        }
        if (metric.getServiceTime() != null && metric.getServiceTime().getValue() != null) {
            metricTO.setServiceTime(((Duration)metric.getServiceTime().getValue()).getTimeInMillis(calendar));
        }
        if (metric.getOperation() == null) {
            throw new WSDMException("The operation in metric cannot be null!!!");
        }
        String[] addr = endpointRef.split("::");
        if (addr == null || addr.length != 2) {
            throw new WSDMException("Endpoint address is not correctly formatted => {ns}ServiceName::EndpointName and not: " + endpointRef);
        }
        QName serviceName = QName.valueOf(addr[0].trim());
        String endpointName = addr[1].trim();
        Endpoint endpoint = this.endpointDAO.getByNameAndServiceFullName(serviceName.toString(), endpointName);
        if (endpoint == null) {
            throw new WSDMException("Impossible to find endpoint: " + endpointRef);
        }
        Binding binding = endpoint.getBinding();
        if (binding != null && (set = binding.getBindingOps()) != null && set.size() > 0) {
            for (BindingOperation bo : set) {
                if (bo.getSpecifiedOp() == null || bo.getSpecifiedOp().getName() == null) continue;
                QName boQName = QName.valueOf(bo.getSpecifiedOp().getName());
                QName metricQName = QName.valueOf(metric.getOperation());
                if (!boQName.toString().equals(metricQName.toString()) && !boQName.getLocalPart().equals(metricQName.getLocalPart())) continue;
                metricTO.setBindingOperation(this.transfertObjectAssembler.toBindingOpTO(bo));
                break;
            }
        }
        if (metricTO.getBindingOperation() == null) {
            throw new WSDMException("Impossible to find the binding operation corresponding to " + metric.getOperation());
        }
        return metricTO;
    }

    public QoSMetricDAO getQoSMetricDAO() {
        return this.qoSMetricDAO;
    }

    public void setQoSMetricDAO(QoSMetricDAO qoSMetricDAO) {
        this.qoSMetricDAO = qoSMetricDAO;
    }

    public TransfertObjectAssembler getTransfertObjectAssembler() {
        return this.transfertObjectAssembler;
    }

    public void setTransfertObjectAssembler(TransfertObjectAssembler transfertObjectAssembler) {
        this.transfertObjectAssembler = transfertObjectAssembler;
    }

    public EndpointDAO getEndpointDAO() {
        return this.endpointDAO;
    }

    public void setEndpointDAO(EndpointDAO endpointDAO) {
        this.endpointDAO = endpointDAO;
    }
}

