/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.wsdm;

import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.service.wsdm.QoSMetricManager;
import org.ow2.dragon.api.service.wsdm.QoSMetricServiceException;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.wsdm.QoSMetricTO;
import org.ow2.dragon.persistence.bo.deployment.Binding;
import org.ow2.dragon.persistence.bo.deployment.BindingOperation;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.wsdm.QoSMetric;
import org.ow2.dragon.persistence.dao.GenericUnifiedDAO;
import org.ow2.dragon.persistence.dao.deployment.BindingDAO;
import org.ow2.dragon.persistence.dao.deployment.BindingOperationDAO;
import org.ow2.dragon.persistence.dao.deployment.EndpointDAO;
import org.ow2.dragon.persistence.dao.wsdm.QoSMetricDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;
import org.ow2.dragon.service.wsdm.SAAJHelper;
import org.ow2.easywsdl.schema.api.XmlException;

public class QoSMetricManagerImpl
implements QoSMetricManager {
    private QoSMetricDAO qoSMetricDAO;
    private BindingOperationDAO bindingOperationDAO;
    private EndpointDAO endpointDAO;
    private BindingDAO bindingDAO;
    private GenericUnifiedDAO<TechnicalService, String> technicalServiceUnifiedDAO;
    private TransfertObjectAssembler transfertObjectAssembler;

    @Override
    public void saveQoSMetric(QoSMetricTO qoSMetricTO) throws DeploymentException {
        this.qoSMetricDAO.save(this.toQoSMetricBO(qoSMetricTO));
    }

    @Override
    public void removeQoSMetric(String qoSMetricId) throws DeploymentException {
        this.qoSMetricDAO.remove(qoSMetricId);
    }

    @Override
    public QoSMetricTO getQoSMetric(String bindingOperationId) throws DeploymentException {
        List qoSMetricBOs = this.qoSMetricDAO.searchEquals(new String[]{bindingOperationId}, new String[]{"bindingOperation.id"}, null);
        if (!qoSMetricBOs.isEmpty()) {
            return this.toQoSMetricTO((QoSMetric)qoSMetricBOs.get(0));
        }
        return null;
    }

    @Override
    public List<QoSMetricTO> getAllQoSMetrics() throws DeploymentException {
        ArrayList<QoSMetricTO> result = new ArrayList<QoSMetricTO>();
        List<QoSMetric> qoSMetrics = this.qoSMetricDAO.getAll();
        this.toQoSMetricsTO(result, qoSMetrics);
        return result;
    }

    @Override
    public void updateQoSMetric(QoSMetricTO qoSMetricTO) throws DeploymentException {
        QoSMetric qoSMetric = (QoSMetric)this.qoSMetricDAO.get(qoSMetricTO.getId());
        if (qoSMetric != null) {
            qoSMetric.setLastRequestSize(qoSMetricTO.getLastRequestSize());
            qoSMetric.setLastResponseSize(qoSMetricTO.getLastResponseSize());
            qoSMetric.setLastResponseTime(qoSMetricTO.getLastResponseTime());
            qoSMetric.setMaxRequestSize(qoSMetricTO.getMaxRequestSize());
            qoSMetric.setMaxResponseSize(qoSMetricTO.getMaxResponseSize());
            qoSMetric.setMaxResponseTime(qoSMetricTO.getMaxResponseTime());
            qoSMetric.setNumberOfFailedRequest(qoSMetricTO.getNumberOfFailedRequest());
            qoSMetric.setNumberOfRequests(qoSMetricTO.getNumberOfRequests());
            qoSMetric.setNumberOfSuccessfulRequest(qoSMetric.getNumberOfSuccessfulRequest());
            qoSMetric.setServiceTime(qoSMetricTO.getServiceTime());
        }
    }

    @Override
    public QoSMetricTO getQoSMetricForEndpoint(String endpointId) throws DeploymentException {
        EndpointTO endpointTO = this.transfertObjectAssembler.toEndpointTO((Endpoint)this.endpointDAO.get(endpointId), null);
        if (endpointTO != null && endpointTO.getBinding() != null) {
            return this.getQoSMetricForBinding(endpointTO.getBinding().getId());
        }
        return null;
    }

    @Override
    public QoSMetricTO getQoSMetricForTechnicalService(String techServiceId) throws DeploymentException {
        TechnicalService technicalServiceBO = this.technicalServiceUnifiedDAO.get(techServiceId);
        ArrayList<QoSMetricTO> qosList = new ArrayList<QoSMetricTO>();
        for (Endpoint endpoint : technicalServiceBO.getEndpoints()) {
            QoSMetricTO qoSMetric = this.getQoSMetricForEndpoint(endpoint.getId());
            if (qoSMetric == null) continue;
            qosList.add(qoSMetric);
        }
        return this.aggregateQoSMetric(qosList);
    }

    @Override
    public QoSMetricTO getQoSMetricForBinding(String bindingId) throws DeploymentException {
        Binding bindingBO = (Binding)this.bindingDAO.get(bindingId);
        Set<BindingOperation> bindingOpsList = bindingBO.getBindingOps();
        ArrayList<QoSMetricTO> qosList = new ArrayList<QoSMetricTO>();
        for (BindingOperation bdoTO : bindingOpsList) {
            QoSMetricTO qoSMetric = this.getQoSMetric(bdoTO.getId());
            if (qoSMetric == null) continue;
            qosList.add(qoSMetric);
        }
        return this.aggregateQoSMetric(qosList);
    }

    private QoSMetricTO aggregateQoSMetric(List<QoSMetricTO> qosList) {
        if (!qosList.isEmpty()) {
            QoSMetricTO result = new QoSMetricTO();
            for (QoSMetricTO to : qosList) {
                result.setLastRequestSize(result.getLastRequestSize() + to.getLastRequestSize());
                result.setLastResponseSize(result.getLastResponseSize() + to.getLastResponseSize());
                result.setLastResponseTime(result.getLastResponseTime() + to.getLastResponseTime());
                result.setMaxRequestSize(result.getMaxRequestSize() + to.getMaxRequestSize());
                result.setMaxResponseSize(result.getMaxResponseSize() + to.getMaxResponseSize());
                result.setMaxResponseTime(result.getMaxResponseTime() + to.getMaxResponseTime());
                result.setNumberOfFailedRequest(result.getNumberOfFailedRequest() + to.getNumberOfFailedRequest());
                result.setNumberOfRequests(result.getNumberOfRequests() + to.getNumberOfRequests());
                result.setNumberOfSuccessfulRequest(result.getNumberOfSuccessfulRequest() + to.getNumberOfSuccessfulRequest());
                result.setServiceTime(result.getServiceTime() + to.getServiceTime());
            }
            result.setLastRequestSize(result.getLastRequestSize() / (long)qosList.size());
            result.setLastResponseSize(result.getLastResponseSize() / (long)qosList.size());
            result.setLastResponseTime(result.getLastResponseTime() / (long)qosList.size());
            result.setMaxRequestSize(result.getMaxRequestSize() / (long)qosList.size());
            result.setMaxResponseSize(result.getMaxResponseSize() / (long)qosList.size());
            result.setMaxResponseTime(result.getMaxResponseTime() / (long)qosList.size());
            result.setNumberOfFailedRequest(result.getNumberOfFailedRequest() / (long)qosList.size());
            result.setNumberOfRequests(result.getNumberOfRequests() / (long)qosList.size());
            result.setNumberOfSuccessfulRequest(result.getNumberOfSuccessfulRequest() / (long)qosList.size());
            result.setServiceTime(result.getServiceTime() / (long)qosList.size());
            return result;
        }
        return null;
    }

    private void toQoSMetricsTO(List<QoSMetricTO> result, List<QoSMetric> qoSMetrics) {
        if (qoSMetrics != null && !qoSMetrics.isEmpty()) {
            for (QoSMetric qoSMetric : qoSMetrics) {
                result.add(this.toQoSMetricTO(qoSMetric));
            }
        }
    }

    private QoSMetricTO toQoSMetricTO(QoSMetric qoSMetric) {
        return this.transfertObjectAssembler.toQoSMetricTO(qoSMetric);
    }

    private QoSMetric toQoSMetricBO(QoSMetricTO qoSMetricTO) {
        QoSMetric qoSMetricBO = new QoSMetric();
        this.transfertObjectAssembler.toQoSMetricBO(qoSMetricTO, qoSMetricBO);
        return qoSMetricBO;
    }

    public QoSMetricDAO getQoSMetricDAO() {
        return this.qoSMetricDAO;
    }

    public void setQoSMetricDAO(QoSMetricDAO qoSMetricDAO) {
        this.qoSMetricDAO = qoSMetricDAO;
    }

    public BindingOperationDAO getBindingOperationDAO() {
        return this.bindingOperationDAO;
    }

    public void setBindingOperationDAO(BindingOperationDAO bindingOperationDAO) {
        this.bindingOperationDAO = bindingOperationDAO;
    }

    public TransfertObjectAssembler getTransfertObjectAssembler() {
        return this.transfertObjectAssembler;
    }

    public void setTransfertObjectAssembler(TransfertObjectAssembler transfertObjectAssembler) {
        this.transfertObjectAssembler = transfertObjectAssembler;
    }

    @Override
    public Map<String, String> getCurrentMessage(String address) throws QoSMetricServiceException {
        try {
            SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection soapConnection = soapConnectionFactory.createConnection();
            URL endpointURL = new URL(address);
            SOAPMessage message = SAAJHelper.createGetCurrentMessageSOAPMessage();
            MimeHeaders headers = message.getMimeHeaders();
            headers.addHeader("SOAPAction", "http://petals.ow2.org/wsdm/GetCurrentMessage");
            SOAPMessage response = soapConnection.call(message, (Object)endpointURL);
        }
        catch (MalformedURLException e) {
            throw new QoSMetricServiceException(e);
        }
        catch (SOAPException e) {
            throw new QoSMetricServiceException(e);
        }
        return null;
    }

    @Override
    public EndpointTO subscribe(String endpointId, String responseAddress) throws QoSMetricServiceException {
        try {
            Endpoint endpoint = (Endpoint)this.endpointDAO.get(endpointId);
            SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection soapConnection = soapConnectionFactory.createConnection();
            URL endpointURL = new URL(endpoint.getSubscriptionAddr());
            SOAPMessage message = SAAJHelper.createSubscribeSOAPMessage(responseAddress);
            MimeHeaders headers = message.getMimeHeaders();
            headers.addHeader("SOAPAction", "http://petals.ow2.org/wsdm/Subscribe");
            SOAPMessage response = soapConnection.call(message, (Object)endpointURL);
            endpoint.setResourcesUuidType(SAAJHelper.extractResourcesUuidType(response).trim());
            endpoint.setSubscription(true);
            this.endpointDAO.save(endpoint);
            soapConnection.close();
            return this.transfertObjectAssembler.toEndpointTO(endpoint, null);
        }
        catch (UnsupportedOperationException e) {
            throw new QoSMetricServiceException(e);
        }
        catch (SOAPException e) {
            throw new QoSMetricServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new QoSMetricServiceException(e);
        }
        catch (WSAddressingException e) {
            throw new QoSMetricServiceException(e);
        }
        catch (XmlException e) {
            throw new QoSMetricServiceException(e);
        }
    }

    @Override
    public EndpointTO unSubscribe(String endpointId, String responseAddress) throws QoSMetricServiceException {
        Endpoint endpoint = (Endpoint)this.endpointDAO.get(endpointId);
        try {
            SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection soapConnection = soapConnectionFactory.createConnection();
            URL endpointURL = new URL(endpoint.getSubscriptionAddr());
            SOAPMessage message = SAAJHelper.createUnSubscribeSOAPMessage(responseAddress, endpoint.getResourcesUuidType());
            MimeHeaders headers = message.getMimeHeaders();
            headers.addHeader("SOAPAction", "http://petals.ow2.org/wsdm/Unsubscribe");
            SOAPMessage response = soapConnection.call(message, (Object)endpointURL);
            endpoint.setResourcesUuidType(null);
            endpoint.setSubscription(false);
            this.endpointDAO.save(endpoint);
            soapConnection.close();
            return this.transfertObjectAssembler.toEndpointTO(endpoint, null);
        }
        catch (UnsupportedOperationException e) {
            throw new QoSMetricServiceException(e);
        }
        catch (SOAPException e) {
            if (e.getCause().equals(ConnectException.class)) {
                throw new QoSMetricServiceException(e.getMessage() + " because, " + e.getCause().getMessage() + ". Check if the address: " + endpoint.getSubscriptionAddr() + "  is reachable.");
            }
            throw new QoSMetricServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new QoSMetricServiceException(e);
        }
        catch (WSAddressingException e) {
            throw new QoSMetricServiceException(e);
        }
        catch (WSNotificationException e) {
            throw new QoSMetricServiceException(e);
        }
        catch (WSNotificationExtensionException e) {
            throw new QoSMetricServiceException(e);
        }
    }

    public EndpointDAO getEndpointDAO() {
        return this.endpointDAO;
    }

    public void setEndpointDAO(EndpointDAO endpointDAO) {
        this.endpointDAO = endpointDAO;
    }

    public BindingDAO getBindingDAO() {
        return this.bindingDAO;
    }

    public void setBindingDAO(BindingDAO bindingDAO) {
        this.bindingDAO = bindingDAO;
    }

    public GenericUnifiedDAO<TechnicalService, String> getTechnicalServiceUnifiedDAO() {
        return this.technicalServiceUnifiedDAO;
    }

    public void setTechnicalServiceUnifiedDAO(GenericUnifiedDAO<TechnicalService, String> technicalServiceUnifiedDAO) {
        this.technicalServiceUnifiedDAO = technicalServiceUnifiedDAO;
    }
}

