/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.wsdm;

import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.FilterType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationWriter;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import java.util.UUID;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.log4j.Logger;
import org.ow2.easywsdl.schema.api.XmlException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAAJHelper {
    private static MessageFactory messageFactory;
    private static Logger logger;

    private SAAJHelper() {
    }

    public static SOAPMessage createSubscribeSOAPMessage(String subscriptionAddress) throws SOAPException, XmlException {
        SOAPMessage message = messageFactory.createMessage();
        SOAPPart part = message.getSOAPPart();
        SOAPEnvelope envelope = part.getEnvelope();
        SOAPBody body = envelope.getBody();
        Subscribe subscribe = SAAJHelper.createSubscribe(subscriptionAddress);
        Document subscribeDocument = WSNotificationWriter.getInstance().writeSubscribe(subscribe);
        body.addDocument(subscribeDocument);
        return message;
    }

    private static Subscribe createSubscribe(String subscriptionAddress) throws XmlException {
        WSNotificationFactory factory = WSNotificationFactory.getInstance();
        Subscribe subscribe = factory.createSubscribe();
        FilterType filterType = factory.createFiltertype();
        EndpointReferenceType endpointReferenceType = WSAddressingFactory.getInstance().newEndpointReferenceType();
        TopicExpressionType topicExpressionType = factory.createTopicExpressionType();
        topicExpressionType.setDialect("http://www.w3.org/TR/1999/REC-xpath-19991116");
        topicExpressionType.setContent("mows-ev:MetricsCapability");
        topicExpressionType.addTopicNameSpace("mows-ev", "http://docs.oasis-open.org/wsdm/2004/12/mows/wsdm-mows-events.xml");
        endpointReferenceType.setAddress(subscriptionAddress);
        filterType.setTopicExpression(topicExpressionType);
        subscribe.setFilter(filterType);
        subscribe.setConsumerReference(endpointReferenceType);
        return subscribe;
    }

    public static String extractResourcesUuidType(SOAPMessage response) throws WSNotificationException, SOAPException, WSNotificationExtensionException, WSAddressingException {
        SOAPPart part = response.getSOAPPart();
        SOAPEnvelope envelope = part.getEnvelope();
        SOAPBody body = envelope.getBody();
        NodeList list = body.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if ("ResourceUuidList".equals(node.getLocalName()) && "http://www.ebmwebsourcing.com/wsnotification/specificTypes".equals(node.getNamespaceURI())) {
                return node.getTextContent();
            }
            Node seekedNode = SAAJHelper.searchNode(node.getChildNodes(), "ResourceUuidList", "http://www.ebmwebsourcing.com/wsnotification/specificTypes");
            if (seekedNode == null) continue;
            return seekedNode.getTextContent();
        }
        return null;
    }

    public static SOAPMessage createUnSubscribeSOAPMessage(String endpointRefAddress, String resourcesUuidType) throws WSNotificationException, SOAPException, WSAddressingException, WSNotificationExtensionException {
        SOAPMessage message = messageFactory.createMessage();
        SOAPPart part = message.getSOAPPart();
        SOAPEnvelope envelope = part.getEnvelope();
        SOAPBody body = envelope.getBody();
        Unsubscribe unSubscribe = SAAJHelper.createUnSubscribe(endpointRefAddress, resourcesUuidType);
        Document unSubscribeDocument = WSNotificationWriter.getInstance().writeUnsubscribe(unSubscribe);
        body.addDocument(unSubscribeDocument);
        return message;
    }

    private static Unsubscribe createUnSubscribe(String endpointRefAddress, String resourcesUuidType) throws WSAddressingException, WSNotificationException, WSNotificationExtensionException {
        Unsubscribe unsubscribePayload = WSNotificationFactory.getInstance().createUnsubscribe();
        EndpointReferenceType edpRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        edpRef.setAddress(endpointRefAddress);
        WsnSpecificTypeHelper.setEndpointReference((EndpointReferenceType)edpRef, (Unsubscribe)unsubscribePayload);
        ResourcesUuidType uuidsToRemove = WSNotificationExtensionFactory.getInstance().createResourcesUuidType();
        uuidsToRemove.addUuid("uuid:" + UUID.randomUUID());
        WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)uuidsToRemove, (Unsubscribe)unsubscribePayload);
        return unsubscribePayload;
    }

    private static Node searchNode(NodeList list, String localName, String namespaceURI) {
        for (int i = 0; i < list.getLength(); ++i) {
            Node seekedNode;
            Node node = list.item(i);
            if (localName.equals(node.getLocalName()) && namespaceURI.equals(node.getNamespaceURI())) {
                return node;
            }
            NodeList subList = node.getChildNodes();
            if (subList == null || subList.getLength() <= 0 || (seekedNode = SAAJHelper.searchNode(subList, localName, namespaceURI)) == null) continue;
            return seekedNode;
        }
        return null;
    }

    public static SOAPMessage createGetCurrentMessageSOAPMessage() throws SOAPException {
        SOAPMessage message = messageFactory.createMessage();
        SOAPPart part = message.getSOAPPart();
        SOAPEnvelope envelope = part.getEnvelope();
        SOAPBody body = envelope.getBody();
        GetCurrentMessage getCurrentMessage = SAAJHelper.createGetCurrentMessage();
        return message;
    }

    private static GetCurrentMessage createGetCurrentMessage() {
        GetCurrentMessage getCurrentMessage = null;
        return getCurrentMessage;
    }

    static {
        logger = Logger.getLogger(SAAJHelper.class);
        try {
            messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException e) {
            logger.error((Object)e.getMessage());
        }
    }
}

