/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * FindQualifiers.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.uddi;

/**
 * @author ofabre - ebmwebsourcing
 * 
 */
public abstract class FindQualifiers {

    private boolean approximateMatch = false;

    private boolean exactMatch = false;

    private boolean caseSensitiveMatch = false;

    private boolean caseInsensitiveMatch = false;

    private boolean sortByNameAsc = false;

    private boolean sortByNameDesc = false;

    private boolean sortByDateAsc = false;

    private boolean sortByDateDesc = false;

    private boolean orAllKeys = false;

    private boolean orLikeKeys = false;

    private boolean combineCategoryBags = false;

    private boolean serviceSubset = false;

    private boolean bindingSubset = false;

    private boolean andAllKeys = false;

    private boolean diacriticInsensitiveMatch = false;

    private boolean diacriticSensitiveMatch = false;

    public boolean isAndAllKeys() {
        return andAllKeys;
    }

    public void setAndAllKeys(boolean andAllKeys) {
        this.andAllKeys = andAllKeys;
        this.orAllKeys = !andAllKeys;
        this.orLikeKeys = !andAllKeys;
    }

    public boolean isApproximateMatch() {
        return approximateMatch;
    }

    public void setApproximateMatch(boolean approximateMatch) {
        this.approximateMatch = approximateMatch;
        this.exactMatch = !approximateMatch;
    }

    public boolean isBindingSubset() {
        return bindingSubset;
    }

    public void setBindingSubset(boolean bindingSubset) {
        this.bindingSubset = bindingSubset;
        this.combineCategoryBags = !bindingSubset;
        this.serviceSubset = !bindingSubset;
    }

    public boolean isCaseInsensitiveMatch() {
        return caseInsensitiveMatch;
    }

    public void setCaseInsensitiveMatch(boolean caseInsensitiveMatch) {
        this.caseInsensitiveMatch = caseInsensitiveMatch;
        this.caseSensitiveMatch = !caseInsensitiveMatch;
        this.exactMatch = !caseInsensitiveMatch;
    }

    public boolean isCaseSensitiveMatch() {
        return caseSensitiveMatch;
    }

    public void setCaseSensitiveMatch(boolean caseSensitiveMatch) {
        this.caseSensitiveMatch = caseSensitiveMatch;
        this.caseInsensitiveMatch = !caseSensitiveMatch;
    }

    public boolean isCombineCategoryBags() {
        return combineCategoryBags;
    }

    public void setCombineCategoryBags(boolean combineCategoryBags) {
        this.combineCategoryBags = combineCategoryBags;
        this.serviceSubset = !combineCategoryBags;
        this.bindingSubset = !combineCategoryBags;
    }

    public boolean isDiacriticInsensitiveMatch() {
        return diacriticInsensitiveMatch;
    }

    public void setDiacriticInsensitiveMatch(boolean diacriticInsensitiveMatch) {
        this.diacriticInsensitiveMatch = diacriticInsensitiveMatch;
        this.diacriticSensitiveMatch = !diacriticInsensitiveMatch;
        this.exactMatch = !diacriticInsensitiveMatch;
    }

    public boolean isDiacriticSensitiveMatch() {
        return diacriticSensitiveMatch;
    }

    public void setDiacriticSensitiveMatch(boolean diacriticSensitiveMatch) {
        this.diacriticSensitiveMatch = diacriticSensitiveMatch;
        this.diacriticInsensitiveMatch = !diacriticSensitiveMatch;
    }

    public boolean isExactMatch() {
        return exactMatch;
    }

    public void setExactMatch(boolean exactMatch) {
        this.exactMatch = exactMatch;
        this.approximateMatch = !exactMatch;
        this.caseInsensitiveMatch = !exactMatch;
        this.diacriticInsensitiveMatch = !exactMatch;
    }

    public boolean isOrAllKeys() {
        return orAllKeys;
    }

    public void setOrAllKeys(boolean orAllKeys) {
        this.orAllKeys = orAllKeys;
        this.andAllKeys = !orAllKeys;
        this.orLikeKeys = !orAllKeys;
    }

    public boolean isOrLikeKeys() {
        return orLikeKeys;
    }

    public void setOrLikeKeys(boolean orLikeKeys) {
        this.orLikeKeys = orLikeKeys;
        this.andAllKeys = !orLikeKeys;
        this.orAllKeys = !orLikeKeys;
    }

    public boolean isServiceSubset() {
        return serviceSubset;
    }

    public void setServiceSubset(boolean serviceSubset) {
        this.serviceSubset = serviceSubset;
        this.combineCategoryBags = !serviceSubset;
        this.bindingSubset = !serviceSubset;
    }

    public boolean isSortByNameAsc() {
        return sortByNameAsc;
    }

    public void setSortByNameAsc(boolean sortByNameAsc) {
        this.sortByNameAsc = sortByNameAsc;
        this.sortByNameDesc = !sortByNameAsc;
    }

    public boolean isSortByNameDesc() {
        return sortByNameDesc;
    }

    public void setSortByNameDesc(boolean sortByNameDesc) {
        this.sortByNameDesc = sortByNameDesc;
        this.sortByNameAsc = !sortByNameDesc;
    }

    public boolean isSortByDateAsc() {
        return sortByDateAsc;
    }

    public void setSortByDateAsc(boolean sortByDateAsc) {
        this.sortByDateAsc = sortByDateAsc;
        this.sortByDateDesc = !sortByDateAsc;
    }

    public boolean isSortByDateDesc() {
        return sortByDateDesc;
    }

    public void setSortByDateDesc(boolean sortByDateDesc) {
        this.sortByDateDesc = sortByDateDesc;
        this.sortByDateAsc = !sortByDateDesc;
    }

}
