/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * FindQualifiersV2.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.uddi.v2.impl;

import java.util.List;

import org.ow2.dragon.service.uddi.FindQualifiers;
import org.ow2.dragon.service.uddi.v2.error.ErrorMessage;
import org.ow2.dragon.service.uddi.v2.error.UnsupportedException;

/**
 * @author ofabre - ebmwebsourcing
 * 
 */
public class FindQualifiersV2 extends FindQualifiers {

    public static final String AND_ALL_KEYS = "andAllKeys";

    public static final String CASE_SENSITIVE_MATCH = "caseSensitiveMatch";

    public static final String COMBINE_CATEGORY_BAGS = "combineCategoryBags";

    public static final String EXACT_MATCH = "exactNameMatch";

    public static final String OR_ALL_KEYS = "orAllKeys";

    public static final String OR_LIKE_KEYS = "orLikeKeys";

    public static final String SERVICE_SUBSET = "serviceSubset";

    public static final String SORT_BY_NAME_ASC = "sortByNameAsc";

    public static final String SORT_BY_NAME_DESC = "sortByNameDesc";

    public static final String SORT_BY_DATE_ASC = "sortByDateAsc";

    public static final String SORT_BY_DATE_DESC = "sortByDateDesc";

    public FindQualifiersV2(org.uddi.api_v2.FindQualifiers findQualifiers)
            throws UnsupportedException {
        // Set UDDI default values
        setDefaults();

        // Map requested find qualifiers
        mapRequestedFindQualifiers(findQualifiers);
    }

    private void setDefaults() {
        this.setExactMatch(false);
        this.setCaseSensitiveMatch(false);
        this.setDiacriticSensitiveMatch(true);
        /*
         * this.setSortByNameAsc(true); this.setSortByDateAsc(true);
         */
    }

    private void mapRequestedFindQualifiers(org.uddi.api_v2.FindQualifiers findQualifiers)
            throws UnsupportedException {
        if (findQualifiers != null) {
            List<String> fqList = findQualifiers.getFindQualifier();
            if (fqList != null) {
                for (String fq : fqList) {
                    if (fq.equalsIgnoreCase(AND_ALL_KEYS))
                        this.setAndAllKeys(true);
                    else if (fq.equalsIgnoreCase(CASE_SENSITIVE_MATCH))
                        this.setCaseSensitiveMatch(true);
                    else if (fq.equalsIgnoreCase(COMBINE_CATEGORY_BAGS))
                        this.setCombineCategoryBags(true);
                    else if (fq.equalsIgnoreCase(EXACT_MATCH))
                        this.setExactMatch(true);
                    else if (fq.equalsIgnoreCase(OR_ALL_KEYS))
                        this.setOrAllKeys(true);
                    else if (fq.equalsIgnoreCase(OR_LIKE_KEYS))
                        this.setOrLikeKeys(true);
                    else if (fq.equalsIgnoreCase(SERVICE_SUBSET))
                        this.setServiceSubset(true);
                    else if (fq.equalsIgnoreCase(SORT_BY_NAME_ASC))
                        this.setSortByNameAsc(true);
                    else if (fq.equalsIgnoreCase(SORT_BY_NAME_DESC))
                        this.setSortByNameDesc(true);
                    else if (fq.equalsIgnoreCase(SORT_BY_DATE_ASC))
                        this.setSortByDateAsc(true);
                    else if (fq.equalsIgnoreCase(SORT_BY_DATE_DESC))
                        this.setSortByDateDesc(true);
                    else {
                        throw new UnsupportedException(new ErrorMessage(
                                "errors.findqualifiers.Unsupported", fq));
                    }
                }
            }
        }
    }
}
