/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * UDDIObjectFactory.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.uddi.v3.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;

import org.ow2.dragon.api.service.dataloader.DataLoaderException;
import org.ow2.dragon.util.JAXBUtil;
import org.uddi.api_v3.SaveTModel;

/**
 * @author ofabre
 * 
 */
public class UDDIObjectFactory {

    private static UDDIObjectFactory instance;

    /**
     * The JAXB unique unmarshaller.
     */
    private static Unmarshaller unmarshaller;

    private static Marshaller marshaller;

    @SuppressWarnings("unchecked")
    private static final List<Class> defaultObjectFactories = new ArrayList<Class>(Arrays
            .asList(new Class[] { org.uddi.api_v3.ObjectFactory.class }));

    /*
     * Private object initializations
     */
    private UDDIObjectFactory() throws DataLoaderException {
        try {
            JAXBContext context = JAXBUtil.createJAXBContext(defaultObjectFactories);
            unmarshaller = context.createUnmarshaller();
            marshaller = context.createMarshaller();
        } catch (final JAXBException e) {
            throw new DataLoaderException(e);
        }
    }

    /**
     * Build the Java UDDI objects from XML documents.
     * 
     * @param fileStream
     *            XML documents including uddi save tmodel request
     * @return The root object of the dataset
     * @throws Exception
     *             The exception raised during the unmarshaller creation or the
     *             exception raised during the build of the java bindings.
     */
    public SaveTModel convertStreamSource2SaveTModel(final Source xmlStream) throws Exception {

        // TODO : Check if it is a Thread safe method
        final JAXBElement<SaveTModel> saveTModel = unmarshaller.unmarshal(xmlStream,
                SaveTModel.class);

        return saveTModel.getValue();

    }

    public static UDDIObjectFactory getInstance() throws DataLoaderException {
        if (instance == null) {
            instance = new UDDIObjectFactory();
        }
        return instance;
    }

}
