/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.uddi.v2.impl;

import java.util.List;
import org.ow2.dragon.service.uddi.FindQualifiers;
import org.ow2.dragon.service.uddi.v2.error.ErrorMessage;
import org.ow2.dragon.service.uddi.v2.error.UnsupportedException;

public class FindQualifiersV2
extends FindQualifiers {
    public static final String AND_ALL_KEYS = "andAllKeys";
    public static final String CASE_SENSITIVE_MATCH = "caseSensitiveMatch";
    public static final String COMBINE_CATEGORY_BAGS = "combineCategoryBags";
    public static final String EXACT_MATCH = "exactNameMatch";
    public static final String OR_ALL_KEYS = "orAllKeys";
    public static final String OR_LIKE_KEYS = "orLikeKeys";
    public static final String SERVICE_SUBSET = "serviceSubset";
    public static final String SORT_BY_NAME_ASC = "sortByNameAsc";
    public static final String SORT_BY_NAME_DESC = "sortByNameDesc";
    public static final String SORT_BY_DATE_ASC = "sortByDateAsc";
    public static final String SORT_BY_DATE_DESC = "sortByDateDesc";

    public FindQualifiersV2(org.uddi.api_v2.FindQualifiers findQualifiers) throws UnsupportedException {
        this.setDefaults();
        this.mapRequestedFindQualifiers(findQualifiers);
    }

    private void setDefaults() {
        this.setExactMatch(false);
        this.setCaseSensitiveMatch(false);
        this.setDiacriticSensitiveMatch(true);
    }

    private void mapRequestedFindQualifiers(org.uddi.api_v2.FindQualifiers findQualifiers) throws UnsupportedException {
        List<String> fqList;
        if (findQualifiers != null && (fqList = findQualifiers.getFindQualifier()) != null) {
            for (String fq : fqList) {
                if (fq.equalsIgnoreCase(AND_ALL_KEYS)) {
                    this.setAndAllKeys(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(CASE_SENSITIVE_MATCH)) {
                    this.setCaseSensitiveMatch(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(COMBINE_CATEGORY_BAGS)) {
                    this.setCombineCategoryBags(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(EXACT_MATCH)) {
                    this.setExactMatch(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(OR_ALL_KEYS)) {
                    this.setOrAllKeys(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(OR_LIKE_KEYS)) {
                    this.setOrLikeKeys(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(SERVICE_SUBSET)) {
                    this.setServiceSubset(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(SORT_BY_NAME_ASC)) {
                    this.setSortByNameAsc(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(SORT_BY_NAME_DESC)) {
                    this.setSortByNameDesc(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(SORT_BY_DATE_ASC)) {
                    this.setSortByDateAsc(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(SORT_BY_DATE_DESC)) {
                    this.setSortByDateDesc(true);
                    continue;
                }
                throw new UnsupportedException(new ErrorMessage("errors.findqualifiers.Unsupported", fq));
            }
        }
    }
}

